// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.filesystem;

import org.refcodes.exception.AbstractRuntimeException;

public abstract class FileSystemRuntimeException extends AbstractRuntimeException {

	private static final long serialVersionUID = 1L;

	public FileSystemRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	public FileSystemRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	public FileSystemRuntimeException( String message, Throwable cause ) {
		super( message, cause );
	}

	public FileSystemRuntimeException( String message ) {
		super( message );
	}

	public FileSystemRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	public FileSystemRuntimeException( Throwable cause ) {
		super( cause );
	}

	static abstract class FileSystemFileRuntimeException extends FileSystemRuntimeException implements FileHandleAccessor {

		private static final long serialVersionUID = 1L;

		private FileHandle _file;


		public FileSystemFileRuntimeException( FileHandle aFile, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_file = aFile;
		}


		public FileSystemFileRuntimeException( FileHandle aFile, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_file = aFile;
		}


		public FileSystemFileRuntimeException( FileHandle aFile, String message, Throwable cause ) {
			super( message, cause );
			_file = aFile;
		}


		public FileSystemFileRuntimeException( FileHandle aFile, String message ) {
			super( message );
			_file = aFile;
		}


		public FileSystemFileRuntimeException( FileHandle aFile, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_file = aFile;
		}


		public FileSystemFileRuntimeException( FileHandle aFile, Throwable cause ) {
			super( cause );
			_file = aFile;
		}

		@Override
		public FileHandle getFile() {
			return _file;
		}
	}
}
