// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.filesystem;

import org.refcodes.filesystem.FileSystemException.FileSystemFileException.FileSystemNoFileAccessException;

public class NoReadAccessException extends FileSystemNoFileAccessException {

	private static final long serialVersionUID = 1L;

	public NoReadAccessException( FileHandle aFile, String aMessage, String aErrorCode ) {
		super( aFile, aMessage, aErrorCode );
	}

	public NoReadAccessException( FileHandle aFile, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aFile, aMessage, aCause, aErrorCode );
	}

	public NoReadAccessException( FileHandle aFile, String message, Throwable cause ) {
		super( aFile, message, cause );
	}

	public NoReadAccessException( FileHandle aFile, String message ) {
		super( aFile, message );
	}

	public NoReadAccessException( FileHandle aFile, Throwable aCause, String aErrorCode ) {
		super( aFile, aCause, aErrorCode );
	}

	public NoReadAccessException( FileHandle aFile, Throwable cause ) {
		super( aFile, cause );
	}

}
