// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.filesystem;

import org.refcodes.filesystem.impls.ChangeRootFileSystemWrapperImpl;

/**
 * This exception is thrown whenever a file system to be accessed which does not
 * exist (any more). E.g. a namespace was removed or renamed for a
 * {@link ChangeRootFileSystemWrapperImpl}.
 */
public class UnknownFileSystemException extends FileSystemException {

	private static final long serialVersionUID = 1L;

	public UnknownFileSystemException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	public UnknownFileSystemException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	public UnknownFileSystemException( String message, Throwable cause ) {
		super( message, cause );
	}

	public UnknownFileSystemException( String message ) {
		super( message );
	}

	public UnknownFileSystemException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	public UnknownFileSystemException( Throwable cause ) {
		super( cause );
	}
}
