/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.refcodes.component.Component;
import org.refcodes.data.Delimiter;
import org.refcodes.filesystem.ConcurrentAccessException;
import org.refcodes.filesystem.FileAlreadyExistsException;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.IllegalFileHandleException;
import org.refcodes.filesystem.IllegalKeyException;
import org.refcodes.filesystem.IllegalNameException;
import org.refcodes.filesystem.IllegalPathException;
import org.refcodes.filesystem.NoCreateAccessException;
import org.refcodes.filesystem.NoDeleteAccessException;
import org.refcodes.filesystem.NoListAccessException;
import org.refcodes.filesystem.NoReadAccessException;
import org.refcodes.filesystem.NoWriteAccessException;
import org.refcodes.filesystem.UnknownFileException;
import org.refcodes.filesystem.UnknownFileSystemException;
import org.refcodes.filesystem.UnknownKeyException;
import org.refcodes.filesystem.UnknownPathException;

public interface FileSystem
extends Component {
    public static final char PATH_DELIMITER = Delimiter.PATH.getChar();

    public boolean hasFile(String var1) throws IllegalKeyException, NoListAccessException, UnknownFileSystemException, IOException;

    public boolean hasFile(String var1, String var2) throws IllegalPathException, IllegalNameException, NoListAccessException, UnknownFileSystemException, IOException;

    public boolean hasFile(FileHandle var1) throws NoListAccessException, UnknownFileSystemException, IOException, IllegalFileHandleException;

    public FileHandle createFile(String var1) throws FileAlreadyExistsException, NoCreateAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException;

    public FileHandle createFile(String var1, String var2) throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, NoListAccessException;

    public FileHandle getFileHandle(String var1) throws NoListAccessException, IllegalKeyException, UnknownFileSystemException, IOException, UnknownKeyException;

    public FileHandle getFileHandle(String var1, String var2) throws NoListAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, UnknownKeyException;

    public void fromFile(FileHandle var1, OutputStream var2) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException;

    public void toFile(FileHandle var1, InputStream var2) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException;

    public InputStream fromFile(FileHandle var1) throws ConcurrentAccessException, UnknownFileException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException;

    public OutputStream toFile(FileHandle var1) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, IllegalFileHandleException;

    public void fromFile(FileHandle var1, File var2) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException;

    public void toFile(FileHandle var1, File var2) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException;

    public void toFile(FileHandle var1, byte[] var2) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException;

    public FileHandle renameFile(FileHandle var1, String var2) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalNameException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException;

    public FileHandle moveFile(FileHandle var1, String var2) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException;

    public void deleteFile(FileHandle var1) throws ConcurrentAccessException, UnknownFileException, NoDeleteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException;

    public boolean hasFiles(String var1, boolean var2) throws NoListAccessException, IllegalPathException, UnknownFileSystemException, IOException;

    public List<FileHandle> getFileHandles(String var1, boolean var2) throws NoListAccessException, UnknownPathException, IllegalPathException, UnknownFileSystemException, IOException;
}

