/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem;

import org.refcodes.exception.AbstractException;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.FileHandleAccessor;
import org.refcodes.mixin.KeyAccessor;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.PathAccessor;

public abstract class FileSystemException
extends AbstractException {
    private static final long serialVersionUID = 1L;

    public FileSystemException(String aMessage, String aErrorCode) {
        super(aMessage, aErrorCode);
    }

    public FileSystemException(String aMessage, Throwable aCause, String aErrorCode) {
        super(aMessage, aCause, aErrorCode);
    }

    public FileSystemException(String message, Throwable cause) {
        super(message, cause);
    }

    public FileSystemException(String message) {
        super(message);
    }

    public FileSystemException(Throwable aCause, String aErrorCode) {
        super(aCause, aErrorCode);
    }

    public FileSystemException(Throwable cause) {
        super(cause);
    }

    static abstract class FileSystemFileException
    extends FileSystemException
    implements FileHandleAccessor {
        private static final long serialVersionUID = 1L;
        private FileHandle _file;

        public FileSystemFileException(FileHandle aFile, String aMessage, String aErrorCode) {
            super(aMessage, aErrorCode);
            this._file = aFile;
        }

        public FileSystemFileException(FileHandle aFile, String aMessage, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
            this._file = aFile;
        }

        public FileSystemFileException(FileHandle aFile, String message, Throwable cause) {
            super(message, cause);
            this._file = aFile;
        }

        public FileSystemFileException(FileHandle aFile, String message) {
            super(message);
            this._file = aFile;
        }

        public FileSystemFileException(FileHandle aFile, Throwable aCause, String aErrorCode) {
            super(aCause, aErrorCode);
            this._file = aFile;
        }

        public FileSystemFileException(FileHandle aFile, Throwable cause) {
            super(cause);
            this._file = aFile;
        }

        @Override
        public FileHandle getFile() {
            return this._file;
        }

        static abstract class FileSystemNoFileAccessException
        extends FileSystemFileException {
            private static final long serialVersionUID = 1L;

            public FileSystemNoFileAccessException(FileHandle aFile, String aMessage, String aErrorCode) {
                super(aFile, aMessage, aErrorCode);
            }

            public FileSystemNoFileAccessException(FileHandle aFile, String aMessage, Throwable aCause, String aErrorCode) {
                super(aFile, aMessage, aCause, aErrorCode);
            }

            public FileSystemNoFileAccessException(FileHandle aFile, String message, Throwable cause) {
                super(aFile, message, cause);
            }

            public FileSystemNoFileAccessException(FileHandle aFile, String message) {
                super(aFile, message);
            }

            public FileSystemNoFileAccessException(FileHandle aFile, Throwable aCause, String aErrorCode) {
                super(aFile, aCause, aErrorCode);
            }

            public FileSystemNoFileAccessException(FileHandle aFile, Throwable cause) {
                super(aFile, cause);
            }
        }
    }

    static abstract class FileSystemKeyException
    extends FileSystemException
    implements KeyAccessor<String> {
        private static final long serialVersionUID = 1L;
        private String _key;

        public FileSystemKeyException(String aKey, String aMessage, String aErrorCode) {
            super(aMessage, aErrorCode);
            this._key = aKey;
        }

        public FileSystemKeyException(String aKey, String aMessage, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
            this._key = aKey;
        }

        public FileSystemKeyException(String aKey, String message, Throwable cause) {
            super(message, cause);
            this._key = aKey;
        }

        public FileSystemKeyException(String aKey, String message) {
            super(message);
            this._key = aKey;
        }

        public FileSystemKeyException(String aKey, Throwable aCause, String aErrorCode) {
            super(aCause, aErrorCode);
            this._key = aKey;
        }

        public FileSystemKeyException(String aKey, Throwable cause) {
            super(cause);
            this._key = aKey;
        }

        public String getKey() {
            return this._key;
        }
    }

    static abstract class FileSystemNameException
    extends FileSystemException
    implements NameAccessor {
        private static final long serialVersionUID = 1L;
        private String _name;

        public FileSystemNameException(String aName, String aMessage, String aErrorCode) {
            super(aMessage, aErrorCode);
            this._name = aName;
        }

        public FileSystemNameException(String aName, String aMessage, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
            this._name = aName;
        }

        public FileSystemNameException(String aName, String message, Throwable cause) {
            super(message, cause);
            this._name = aName;
        }

        public FileSystemNameException(String aName, String message) {
            super(message);
            this._name = aName;
        }

        public FileSystemNameException(String aName, Throwable aCause, String aErrorCode) {
            super(aCause, aErrorCode);
            this._name = aName;
        }

        public FileSystemNameException(String aName, Throwable cause) {
            super(cause);
            this._name = aName;
        }

        public String getName() {
            return this._name;
        }
    }

    static abstract class FileSystemNoFileSystemAccessException
    extends FileSystemException {
        private static final long serialVersionUID = 1L;

        public FileSystemNoFileSystemAccessException(String aMessage, String aErrorCode) {
            super(aMessage, aErrorCode);
        }

        public FileSystemNoFileSystemAccessException(String aMessage, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
        }

        public FileSystemNoFileSystemAccessException(String message, Throwable cause) {
            super(message, cause);
        }

        public FileSystemNoFileSystemAccessException(String message) {
            super(message);
        }

        public FileSystemNoFileSystemAccessException(Throwable aCause, String aErrorCode) {
            super(aCause, aErrorCode);
        }

        public FileSystemNoFileSystemAccessException(Throwable cause) {
            super(cause);
        }
    }

    static abstract class FileSystemPathException
    extends FileSystemException
    implements PathAccessor {
        private static final long serialVersionUID = 1L;
        private String _path;

        public FileSystemPathException(String aPath, String aMessage, String aErrorCode) {
            super(aMessage, aErrorCode);
            this._path = aPath;
        }

        public FileSystemPathException(String aPath, String aMessage, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
            this._path = aPath;
        }

        public FileSystemPathException(String aPath, String message, Throwable cause) {
            super(message, cause);
            this._path = aPath;
        }

        public FileSystemPathException(String aPath, String message) {
            super(message);
            this._path = aPath;
        }

        public FileSystemPathException(String aPath, Throwable aCause, String aErrorCode) {
            super(aCause, aErrorCode);
            this._path = aPath;
        }

        public FileSystemPathException(String aPath, Throwable cause) {
            super(cause);
            this._path = aPath;
        }

        public String getPath() {
            return this._path;
        }
    }
}

