/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem;

import java.util.List;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.FileSystem;
import org.refcodes.filesystem.IllegalFileHandleException;
import org.refcodes.filesystem.IllegalKeyException;
import org.refcodes.filesystem.IllegalNameException;
import org.refcodes.filesystem.IllegalPathException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;

public final class FileSystemUtility {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String RELATIVE_PATH_ELEMENT = "..";

    private FileSystemUtility() {
    }

    public static String toNormalizedPath(String aPath) {
        if ((aPath = aPath.replaceAll("" + FileSystem.PATH_DELIMITER, "" + FileSystem.PATH_DELIMITER)).startsWith("" + FileSystem.PATH_DELIMITER)) {
            aPath = aPath.substring(1);
        }
        return aPath;
    }

    public static String getName(String aKey) {
        String name = aKey.substring(aKey.lastIndexOf(FileSystem.PATH_DELIMITER) + 1);
        return name;
    }

    public static String getPath(String aKey) {
        String path = aKey.subSequence(0, aKey.lastIndexOf(FileSystem.PATH_DELIMITER)).toString();
        return path;
    }

    public static String toKey(String aPath, String aName) {
        return String.valueOf(aPath) + FileSystem.PATH_DELIMITER + aName;
    }

    public static void deleteFiles(FileSystem aFileSystem, String aPath, boolean isRecursively) {
        block6: {
            try {
                if (!aFileSystem.hasFiles(aPath, isRecursively)) break block6;
                List<FileHandle> theFiles = aFileSystem.getFileHandles(aPath, isRecursively);
                for (FileHandle eFile : theFiles) {
                    if (LOGGER.isLogDebug()) {
                        LOGGER.debug("Trying to delete file (handle) with key \"" + eFile.toKey() + "\"...");
                    }
                    try {
                        aFileSystem.deleteFile(eFile);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Unable to delete a file (handle) for path \"" + aPath + "\" though continuing with next entry (" + (isRecursively ? "recursive" : "non-recursive") + "): " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
                    }
                    LOGGER.debug("Deleted file (handle) with key \"" + eFile.toKey() + "\"!");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Unable to delete file (handles) for path \"" + aPath + "\" and will abort (" + (isRecursively ? "recursive" : "non-recursive") + "): " + ExceptionUtility.toMessage((Throwable)e), (Throwable)e);
            }
        }
    }

    public static String toTruncated(String aPath) {
        if (aPath.startsWith("" + FileSystem.PATH_DELIMITER)) {
            aPath = aPath.substring(1);
        }
        return aPath;
    }

    public static String toNormalizedPath(String aPath, FileSystem aFileSystem) throws IllegalPathException {
        if (aPath.contains(RELATIVE_PATH_ELEMENT)) {
            throw new IllegalPathException(aPath, "The given path containes relative path elements \"..\" which may cause a jail break from the provided name space.");
        }
        return FileSystemUtility.toTruncated(aPath);
    }

    public static String toNormalizedKey(String aKey, FileSystem aFileSystem) throws IllegalKeyException {
        if (aKey.contains(RELATIVE_PATH_ELEMENT)) {
            throw new IllegalKeyException(aKey, "The given key containes relative path elements \"..\" which may cause a jail break from the provided name space.");
        }
        return FileSystemUtility.toTruncated(aKey);
    }

    public static String toNormalizedName(String aName, FileSystem aFileSystem) throws IllegalNameException {
        if (aName.contains(RELATIVE_PATH_ELEMENT)) {
            throw new IllegalNameException(aName, "The given name containes relative path elements \"..\" which may cause a jail break from the provided name space.");
        }
        return FileSystemUtility.toTruncated(aName);
    }

    public static FileHandle toNormalizedFileHandle(FileHandle aFileHandle, FileSystem aFileSystem) throws IllegalFileHandleException {
        if (aFileHandle.getName().contains(RELATIVE_PATH_ELEMENT) || aFileHandle.getPath().contains(RELATIVE_PATH_ELEMENT)) {
            throw new IllegalFileHandleException(aFileHandle, "The given file handle containes relative path elements \"..\" which may cause a jail break from the provided name space.");
        }
        return aFileHandle;
    }
}

