/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem.impls;

import java.util.Date;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.FileSystemUtility;

public class FileHandleImpl
implements FileHandle {
    protected String _path;
    protected String _name;
    protected long _size;
    protected Date _createdDate;
    protected Date _modifiedDate;

    public FileHandleImpl(String aPath, String aName, long aSize, Date aCreatedDate, Date aModifiedDate) {
        this._path = aPath;
        this._name = aName;
        this._size = aSize;
        this._createdDate = aCreatedDate;
        this._modifiedDate = aModifiedDate;
    }

    public FileHandleImpl(String aKey) {
        this._path = FileSystemUtility.getPath(aKey);
        this._name = FileSystemUtility.getName(aKey);
    }

    public FileHandleImpl(String aPath, String aName) {
        this._path = aPath;
        this._name = aName;
    }

    public FileHandleImpl(FileHandle aFileHandle) {
        this._path = aFileHandle.getPath();
        this._name = aFileHandle.getName();
        this._size = aFileHandle.getSize();
        this._createdDate = aFileHandle.getCreatedDate();
        this._modifiedDate = aFileHandle.getModifiedDate();
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String toKey() {
        return FileSystemUtility.toKey(this._path, this._name);
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public Date getCreatedDate() {
        return this._createdDate;
    }

    @Override
    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._path == null ? 0 : this._path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (MutableFileHandleImpl.class != obj.getClass() && FileHandleImpl.class != obj.getClass()) {
            return false;
        }
        FileHandle other = (FileHandle)obj;
        if (this._name == null ? other.getName() != null : !this._name.equals(other.getName())) {
            return false;
        }
        return !(this._path == null ? other.getPath() != null : !this._path.equals(other.getPath()));
    }

    @Override
    public FileHandle.MutableFileHandle toMutableFileHandle() {
        return new MutableFileHandleImpl(this);
    }

    public class MutableFileHandleImpl
    extends FileHandleImpl
    implements FileHandle.MutableFileHandle {
        public MutableFileHandleImpl(String aPath, String aName, long aSize, Date aCreatedDate, Date aModifiedDate) {
            super(aPath, aName, aSize, aCreatedDate, aModifiedDate);
        }

        public MutableFileHandleImpl(FileHandle aFileHandle) {
            super(aFileHandle);
        }

        public void setModifiedDate(Date aModifiedDate) {
            this._modifiedDate = aModifiedDate;
        }

        public void setSize(long aSize) {
            this._size = aSize;
        }

        public void setName(String aName) {
            this._name = aName;
        }

        public void setPath(String aPath) {
            this._path = aPath;
        }

        public void setCreatedDate(Date aCreatedDate) {
            this._createdDate = aCreatedDate;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        @Override
        public FileHandle toFileHandle() {
            return new FileHandleImpl(this);
        }
    }
}

