/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem.impls;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.refcodes.filesystem.ConcurrentAccessException;
import org.refcodes.filesystem.FileAlreadyExistsException;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.FileSystem;
import org.refcodes.filesystem.FileSystemUtility;
import org.refcodes.filesystem.IllegalFileHandleException;
import org.refcodes.filesystem.IllegalKeyException;
import org.refcodes.filesystem.IllegalNameException;
import org.refcodes.filesystem.IllegalPathException;
import org.refcodes.filesystem.NoCreateAccessException;
import org.refcodes.filesystem.NoDeleteAccessException;
import org.refcodes.filesystem.NoListAccessException;
import org.refcodes.filesystem.NoReadAccessException;
import org.refcodes.filesystem.NoWriteAccessException;
import org.refcodes.filesystem.UnknownFileException;
import org.refcodes.filesystem.UnknownFileSystemException;
import org.refcodes.filesystem.UnknownKeyException;
import org.refcodes.filesystem.UnknownPathException;
import org.refcodes.filesystem.impls.FileHandleImpl;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;

public class InMemoryFileSystemImpl
implements FileSystem {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private Map<FileHandle, byte[]> _fileSystemMap = new ConcurrentHashMap<FileHandle, byte[]>();

    @Override
    public boolean hasFile(String aKey) throws IllegalKeyException, NoListAccessException, UnknownFileSystemException, IOException {
        return this._fileSystemMap.containsKey(new FileHandleImpl(aKey));
    }

    @Override
    public boolean hasFile(String aPath, String aName) throws IllegalPathException, IllegalNameException, NoListAccessException, UnknownFileSystemException, IOException {
        return this._fileSystemMap.containsKey(new FileHandleImpl(aPath, aName));
    }

    @Override
    public boolean hasFile(FileHandle aFileHandle) throws NoListAccessException, UnknownFileSystemException, IOException, IllegalFileHandleException {
        return this._fileSystemMap.containsKey(aFileHandle);
    }

    @Override
    public FileHandle createFile(String aKey) throws FileAlreadyExistsException, NoCreateAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException {
        Date theDate = new Date();
        FileHandleImpl theFileHandle = new FileHandleImpl(FileSystemUtility.getPath(aKey), FileSystemUtility.getName(aKey), 0L, theDate, theDate);
        if (this._fileSystemMap.containsKey(theFileHandle)) {
            throw new FileAlreadyExistsException(aKey, "The file with the key \"" + aKey + "\" already exists.");
        }
        this._fileSystemMap.put(theFileHandle, new byte[0]);
        return theFileHandle;
    }

    @Override
    public FileHandle createFile(String aPath, String aName) throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, NoListAccessException {
        Date theDate = new Date();
        FileHandleImpl theFileHandle = new FileHandleImpl(aPath, aName, 0L, theDate, theDate);
        if (this._fileSystemMap.containsKey(theFileHandle)) {
            throw new FileAlreadyExistsException(theFileHandle.toKey(), "The file with the key \"" + theFileHandle.toKey() + "\" already exists.");
        }
        this._fileSystemMap.put(theFileHandle, new byte[0]);
        return theFileHandle;
    }

    @Override
    public FileHandle getFileHandle(String aKey) throws NoListAccessException, IllegalKeyException, UnknownFileSystemException, IOException, UnknownKeyException {
        FileHandle theFileHandle = new FileHandleImpl(aKey);
        if ((theFileHandle = this.toFileHandle(theFileHandle)) == null) {
            throw new UnknownKeyException(aKey, "The file with the key \"" + aKey + "\" does not exist.");
        }
        return theFileHandle;
    }

    @Override
    public FileHandle getFileHandle(String aPath, String aName) throws NoListAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, UnknownKeyException {
        FileHandleImpl theFileHandle = new FileHandleImpl(aPath, aName);
        for (FileHandle eFileHandle : this._fileSystemMap.keySet()) {
            if (!eFileHandle.equals(theFileHandle)) continue;
            return eFileHandle;
        }
        throw new UnknownKeyException(FileSystemUtility.toKey(aPath, aName), "The file with the path \"" + aPath + "\" and name \"" + aName + "\" ( = key \"" + FileSystemUtility.toKey(aPath, aName) + "\") does not exist.");
    }

    @Override
    public void fromFile(FileHandle aFromFileHandle, OutputStream aOutputStream) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        byte[] theBuffer = this._fileSystemMap.get(aFromFileHandle);
        if (theBuffer == null) {
            throw new UnknownFileException(aFromFileHandle, "The (from) file with the key \"" + aFromFileHandle.toKey() + "\" does not exist.");
        }
        aOutputStream.write(theBuffer);
        aOutputStream.flush();
    }

    @Override
    public synchronized void toFile(FileHandle aToFileHandle, InputStream aInputStream) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this.hasFile(aToFileHandle)) {
            throw new UnknownFileException(aToFileHandle, "The (to) file with the key \"" + aToFileHandle.toKey() + "\" does not exist.");
        }
        byte[] theBuffer = IOUtils.toByteArray((InputStream)aInputStream);
        FileHandle.MutableFileHandle theMutableToFileHandle = aToFileHandle.toMutableFileHandle();
        theMutableToFileHandle.setSize(theBuffer.length);
        this._fileSystemMap.put(theMutableToFileHandle.toFileHandle(), theBuffer);
    }

    @Override
    public synchronized InputStream fromFile(FileHandle aFromFileHandle) throws ConcurrentAccessException, UnknownFileException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        byte[] theBuffer = this._fileSystemMap.get(aFromFileHandle);
        if (theBuffer == null) {
            throw new UnknownFileException(aFromFileHandle, "The (from) file with the key \"" + aFromFileHandle.toKey() + "\" does not exist.");
        }
        return new ByteArrayInputStream(theBuffer);
    }

    @Override
    public OutputStream toFile(final FileHandle aToFileHandle) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, IllegalFileHandleException {
        if (!this._fileSystemMap.containsKey(aToFileHandle)) {
            throw new UnknownFileException(aToFileHandle, "The (to) file with the key \"" + aToFileHandle.toKey() + "\" does not exist.");
        }
        final PipedInputStream thePipedInputStream = new PipedInputStream();
        PipedOutputStream thePipedOutputStream = new PipedOutputStream(thePipedInputStream);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    byte[] theBuffer = IOUtils.toByteArray((InputStream)thePipedInputStream);
                    FileHandle.MutableFileHandle theMutableToFileHandle = aToFileHandle.toMutableFileHandle();
                    theMutableToFileHandle.setSize(theBuffer.length);
                    InMemoryFileSystemImpl.this._fileSystemMap.put(theMutableToFileHandle.toFileHandle(), theBuffer);
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to write the output stream to the file with key \"" + aToFileHandle.toKey() + "\".", (Throwable)e);
                }
            }
        };
        t.start();
        return thePipedOutputStream;
    }

    @Override
    public void fromFile(FileHandle aFromFileHandle, File aToFile) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        byte[] theBuffer = this._fileSystemMap.get(aFromFileHandle);
        if (theBuffer == null) {
            throw new UnknownFileException(aFromFileHandle, "The (from) file with the key \"" + aFromFileHandle.toKey() + "\" does not exist.");
        }
        FileOutputStream theOutputStream = new FileOutputStream(aToFile);
        IOUtils.copy((InputStream)new ByteArrayInputStream(theBuffer), (OutputStream)theOutputStream);
    }

    @Override
    public void toFile(FileHandle aToFileHandle, File aFromFile) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this._fileSystemMap.containsKey(aToFileHandle)) {
            throw new UnknownFileException(aToFileHandle, "The (to) file with the key \"" + aToFileHandle.toKey() + "\" does not exist.");
        }
        FileInputStream theFileInputStream = new FileInputStream(aFromFile);
        byte[] theBuffer = IOUtils.toByteArray((InputStream)theFileInputStream);
        this._fileSystemMap.put(aToFileHandle, theBuffer);
    }

    @Override
    public void toFile(FileHandle aToFileHandle, byte[] aBuffer) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        if (!this._fileSystemMap.containsKey(aToFileHandle)) {
            throw new UnknownFileException(aToFileHandle, "The (to) file with the key \"" + aToFileHandle.toKey() + "\" does not exist.");
        }
        FileHandle.MutableFileHandle theMutableToFileHandle = aToFileHandle.toMutableFileHandle();
        theMutableToFileHandle.setSize(aBuffer.length);
        this._fileSystemMap.put(theMutableToFileHandle.toFileHandle(), aBuffer);
    }

    @Override
    public synchronized FileHandle renameFile(FileHandle aFileHandle, String aNewName) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalNameException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        FileHandle theFileHandle = this.toFileHandle(aFileHandle);
        if (theFileHandle == null) {
            throw new UnknownFileException(aFileHandle, "The file with the key \"" + aFileHandle.toKey() + "\" does not exist.");
        }
        FileHandle.MutableFileHandle theMutableNewFileHandle = theFileHandle.toMutableFileHandle();
        theMutableNewFileHandle.setName(FileSystemUtility.getName(aNewName));
        FileHandle theNewFileHandle = theMutableNewFileHandle.toFileHandle();
        if (this._fileSystemMap.containsKey(theNewFileHandle)) {
            throw new FileAlreadyExistsException(theNewFileHandle.toKey(), "The file with the key \"" + theNewFileHandle.toKey() + "\" already exist.");
        }
        byte[] theBuffer = this._fileSystemMap.remove(theFileHandle);
        this._fileSystemMap.put(theNewFileHandle, theBuffer);
        return theNewFileHandle;
    }

    @Override
    public synchronized FileHandle moveFile(FileHandle aFileHandle, String aNewKey) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        FileHandle theFileHandle = this.toFileHandle(aFileHandle);
        if (theFileHandle == null) {
            throw new UnknownFileException(aFileHandle, "The file with the key \"" + aFileHandle.toKey() + "\" does not exist.");
        }
        FileHandle.MutableFileHandle theMutableNewFileHandle = theFileHandle.toMutableFileHandle();
        theMutableNewFileHandle.setPath(FileSystemUtility.getPath(aNewKey));
        theMutableNewFileHandle.setName(FileSystemUtility.getName(aNewKey));
        FileHandle theNewFileHandle = theMutableNewFileHandle.toFileHandle();
        if (this._fileSystemMap.containsKey(theNewFileHandle)) {
            throw new FileAlreadyExistsException(theNewFileHandle.toKey(), "The file with the key \"" + aFileHandle.toKey() + "\" already exist.");
        }
        byte[] theBuffer = this._fileSystemMap.remove(theFileHandle);
        this._fileSystemMap.put(theNewFileHandle, theBuffer);
        return theNewFileHandle;
    }

    @Override
    public void deleteFile(FileHandle aFileHandle) throws ConcurrentAccessException, UnknownFileException, NoDeleteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileHandleException {
        FileHandle theFileHandle = this.toFileHandle(aFileHandle);
        if (theFileHandle == null) {
            throw new UnknownFileException(aFileHandle, "The file with the key \"" + aFileHandle.toKey() + "\" does not exist.");
        }
        this._fileSystemMap.remove(theFileHandle);
    }

    @Override
    public boolean hasFiles(String aPath, boolean isRecursively) throws NoListAccessException, IllegalPathException, UnknownFileSystemException, IOException {
        for (FileHandle eFileHandle : this._fileSystemMap.keySet()) {
            if (!(isRecursively ? eFileHandle.getPath().equals(aPath) || eFileHandle.getPath().startsWith(String.valueOf(aPath) + PATH_DELIMITER) : eFileHandle.getPath().equals(aPath))) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FileHandle> getFileHandles(String aPath, boolean isRecursively) throws NoListAccessException, UnknownPathException, IllegalPathException, UnknownFileSystemException, IOException {
        ArrayList<FileHandle> theFileHandles = new ArrayList<FileHandle>();
        for (FileHandle eFileHandle : this._fileSystemMap.keySet()) {
            if (isRecursively) {
                if (!eFileHandle.getPath().equals(aPath) && !eFileHandle.getPath().startsWith(String.valueOf(aPath) + PATH_DELIMITER)) continue;
                theFileHandles.add(eFileHandle);
                continue;
            }
            if (!eFileHandle.getPath().equals(aPath)) continue;
            theFileHandles.add(eFileHandle);
        }
        return theFileHandles;
    }

    public void destroy() {
        this._fileSystemMap.clear();
    }

    private FileHandle toFileHandle(FileHandle aFileHandle) {
        for (FileHandle eFileHandle : this._fileSystemMap.keySet()) {
            if (!eFileHandle.equals(aFileHandle)) continue;
            return eFileHandle;
        }
        return null;
    }
}

