// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.filesystem;

/**
 * This exception is thrown whenever a file system is to be created though it
 * already exists. E.g. when using a {@link ChangeRootFileSystemWrapperImpl} and
 * creating it from scratch for a namespace which already exists.
 */
public class FileSystemAlreadyExistsException extends FileSystemException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new file system already exists exception.
	 *
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public FileSystemAlreadyExistsException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new file system already exists exception.
	 *
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public FileSystemAlreadyExistsException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new file system already exists exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public FileSystemAlreadyExistsException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new file system already exists exception.
	 *
	 * @param message the message
	 */
	public FileSystemAlreadyExistsException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new file system already exists exception.
	 *
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public FileSystemAlreadyExistsException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new file system already exists exception.
	 *
	 * @param cause the cause
	 */
	public FileSystemAlreadyExistsException( Throwable cause ) {
		super( cause );
	}
}
