// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.filesystem;

import org.refcodes.filesystem.FileSystemException.FileSystemFileException;

/**
 * The Class IllegalFileHandleException.
 */
public class IllegalFileHandleException extends FileSystemFileException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new illegal file handle exception.
	 *
	 * @param aFile the file
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public IllegalFileHandleException( FileHandle aFile, String aMessage, String aErrorCode ) {
		super( aFile, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new illegal file handle exception.
	 *
	 * @param aFile the file
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public IllegalFileHandleException( FileHandle aFile, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aFile, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new illegal file handle exception.
	 *
	 * @param aFile the file
	 * @param message the message
	 * @param cause the cause
	 */
	public IllegalFileHandleException( FileHandle aFile, String message, Throwable cause ) {
		super( aFile, message, cause );
	}

	/**
	 * Instantiates a new illegal file handle exception.
	 *
	 * @param aFile the file
	 * @param message the message
	 */
	public IllegalFileHandleException( FileHandle aFile, String message ) {
		super( aFile, message );
	}

	/**
	 * Instantiates a new illegal file handle exception.
	 *
	 * @param aFile the file
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public IllegalFileHandleException( FileHandle aFile, Throwable aCause, String aErrorCode ) {
		super( aFile, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new illegal file handle exception.
	 *
	 * @param aFile the file
	 * @param cause the cause
	 */
	public IllegalFileHandleException( FileHandle aFile, Throwable cause ) {
		super( aFile, cause );
	}
}
