/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.refcodes.filesystem.ConcurrentAccessException;
import org.refcodes.filesystem.FileAlreadyExistsException;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.FileSystem;
import org.refcodes.filesystem.FileSystemUtility;
import org.refcodes.filesystem.IllegalFileException;
import org.refcodes.filesystem.IllegalKeyException;
import org.refcodes.filesystem.IllegalNameException;
import org.refcodes.filesystem.IllegalPathException;
import org.refcodes.filesystem.NoCreateAccessException;
import org.refcodes.filesystem.NoDeleteAccessException;
import org.refcodes.filesystem.NoListAccessException;
import org.refcodes.filesystem.NoReadAccessException;
import org.refcodes.filesystem.NoWriteAccessException;
import org.refcodes.filesystem.UnknownFileException;
import org.refcodes.filesystem.UnknownFileSystemException;
import org.refcodes.filesystem.UnknownKeyException;
import org.refcodes.filesystem.UnknownPathException;

public class ChangeRootFileSystemDecorator
implements FileSystem {
    private final String _namespace;
    private final FileSystem _fileSystem;

    public ChangeRootFileSystemDecorator(String aNamespace, FileSystem aFileSystem) {
        this._namespace = aNamespace;
        this._fileSystem = aFileSystem;
    }

    @Override
    public boolean hasFile(String aKey) throws IllegalKeyException, NoListAccessException, UnknownFileSystemException, IOException {
        aKey = FileSystemUtility.toNormalizedKey((String)aKey, this);
        aKey = this._namespace + PATH_DELIMITER + (String)aKey;
        return this._fileSystem.hasFile((String)aKey);
    }

    @Override
    public boolean hasFile(String aPath, String aName) throws IllegalPathException, IllegalNameException, NoListAccessException, UnknownFileSystemException, IOException {
        aPath = FileSystemUtility.toNormalizedPath((String)aPath, this);
        aName = FileSystemUtility.toNormalizedName(aName, this);
        aPath = this._namespace + PATH_DELIMITER + (String)aPath;
        return this._fileSystem.hasFile((String)aPath, aName);
    }

    @Override
    public boolean hasFile(FileHandle aFileHandle) throws NoListAccessException, UnknownFileSystemException, IOException, IllegalFileException {
        aFileHandle = FileSystemUtility.toNormalizedFileHandle(aFileHandle, this);
        FileHandle.MutableFileHandle theMutableFileHandle = aFileHandle.toMutableFileHandle();
        theMutableFileHandle.setPath(this.toRealPath(aFileHandle));
        return this._fileSystem.hasFile(theMutableFileHandle.toFileHandle());
    }

    @Override
    public FileHandle createFile(String aKey) throws FileAlreadyExistsException, NoCreateAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException {
        aKey = FileSystemUtility.toNormalizedKey((String)aKey, this);
        aKey = this._namespace + PATH_DELIMITER + (String)aKey;
        FileHandle theFileHandle = this._fileSystem.createFile((String)aKey);
        FileHandle.MutableFileHandle theMutableFileHandle = theFileHandle.toMutableFileHandle();
        theMutableFileHandle.setPath(this.toVirtualPath(theFileHandle));
        return theMutableFileHandle.toFileHandle();
    }

    @Override
    public FileHandle createFile(String aPath, String aName) throws FileAlreadyExistsException, NoCreateAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, NoListAccessException {
        aPath = FileSystemUtility.toNormalizedPath((String)aPath, this);
        aName = FileSystemUtility.toNormalizedPath(aName, this);
        aPath = this._namespace + PATH_DELIMITER + (String)aPath;
        FileHandle theFileHandle = this._fileSystem.createFile((String)aPath, aName);
        FileHandle.MutableFileHandle theMutableFileHandle = theFileHandle.toMutableFileHandle();
        theMutableFileHandle.setPath(this.toVirtualPath(theFileHandle));
        return theMutableFileHandle.toFileHandle();
    }

    @Override
    public FileHandle getFileHandle(String aKey) throws NoListAccessException, IllegalKeyException, UnknownFileSystemException, IOException, UnknownKeyException {
        aKey = FileSystemUtility.toNormalizedKey((String)aKey, this);
        aKey = this._namespace + PATH_DELIMITER + (String)aKey;
        FileHandle theFileHandle = this._fileSystem.getFileHandle((String)aKey);
        FileHandle.MutableFileHandle theMutableFileHandle = theFileHandle.toMutableFileHandle();
        theMutableFileHandle.setPath(this.toVirtualPath(theFileHandle));
        return theMutableFileHandle.toFileHandle();
    }

    @Override
    public FileHandle getFileHandle(String aPath, String aName) throws NoListAccessException, IllegalNameException, IllegalPathException, UnknownFileSystemException, IOException, UnknownKeyException {
        aPath = FileSystemUtility.toNormalizedPath((String)aPath, this);
        aName = FileSystemUtility.toNormalizedName(aName, this);
        aPath = this._namespace + PATH_DELIMITER + (String)aPath;
        FileHandle theFileHandle = this._fileSystem.getFileHandle((String)aPath, aName);
        FileHandle.MutableFileHandle theMutableFileHandle = theFileHandle.toMutableFileHandle();
        theMutableFileHandle.setPath(this.toVirtualPath(theFileHandle));
        return theMutableFileHandle.toFileHandle();
    }

    @Override
    public void fromFile(FileHandle aFromFileHandle, OutputStream aOutputStream) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileException {
        aFromFileHandle = FileSystemUtility.toNormalizedFileHandle(aFromFileHandle, this);
        FileHandle.MutableFileHandle theMutableFromFileHandle = aFromFileHandle.toMutableFileHandle();
        theMutableFromFileHandle.setPath(this.toRealPath(aFromFileHandle));
        this._fileSystem.fromFile(theMutableFromFileHandle.toFileHandle(), aOutputStream);
    }

    @Override
    public void toFile(FileHandle aToFileHandle, InputStream aInputStream) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileException {
        aToFileHandle = FileSystemUtility.toNormalizedFileHandle(aToFileHandle, this);
        FileHandle.MutableFileHandle theMutableToFileHandle = aToFileHandle.toMutableFileHandle();
        theMutableToFileHandle.setPath(this.toRealPath(aToFileHandle));
        this._fileSystem.toFile(theMutableToFileHandle.toFileHandle(), aInputStream);
    }

    @Override
    public InputStream fromFile(FileHandle aFromFileHandle) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileException {
        aFromFileHandle = FileSystemUtility.toNormalizedFileHandle(aFromFileHandle, this);
        FileHandle.MutableFileHandle theMutableFromFileHandle = aFromFileHandle.toMutableFileHandle();
        theMutableFromFileHandle.setPath(this.toRealPath(aFromFileHandle));
        return this._fileSystem.fromFile(theMutableFromFileHandle.toFileHandle());
    }

    @Override
    public OutputStream toFile(FileHandle aToFileHandle) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, IllegalFileException {
        aToFileHandle = FileSystemUtility.toNormalizedFileHandle(aToFileHandle, this);
        FileHandle.MutableFileHandle theMutableToFileHandle = aToFileHandle.toMutableFileHandle();
        theMutableToFileHandle.setPath(this.toRealPath(aToFileHandle));
        return this._fileSystem.toFile(theMutableToFileHandle.toFileHandle());
    }

    @Override
    public void fromFile(FileHandle aFromFileHandle, File aToFile) throws ConcurrentAccessException, UnknownFileException, NoReadAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileException {
        aFromFileHandle = FileSystemUtility.toNormalizedFileHandle(aFromFileHandle, this);
        FileHandle.MutableFileHandle theMutableFromFileHandle = aFromFileHandle.toMutableFileHandle();
        theMutableFromFileHandle.setPath(this.toRealPath(aFromFileHandle));
        this._fileSystem.fromFile(theMutableFromFileHandle.toFileHandle(), aToFile);
    }

    @Override
    public void toFile(FileHandle aToFileHandle, File aFromFile) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileException {
        aToFileHandle = FileSystemUtility.toNormalizedFileHandle(aToFileHandle, this);
        FileHandle.MutableFileHandle theMutableToFileHandle = aToFileHandle.toMutableFileHandle();
        theMutableToFileHandle.setPath(this.toRealPath(aToFileHandle));
        this._fileSystem.toFile(theMutableToFileHandle.toFileHandle(), aFromFile);
    }

    @Override
    public void toFile(FileHandle aToFileHandle, byte[] aBuffer) throws ConcurrentAccessException, UnknownFileException, NoWriteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileException {
        aToFileHandle = FileSystemUtility.toNormalizedFileHandle(aToFileHandle, this);
        FileHandle.MutableFileHandle theMutableToFileHandle = aToFileHandle.toMutableFileHandle();
        theMutableToFileHandle.setPath(this.toRealPath(aToFileHandle));
        this._fileSystem.toFile(theMutableToFileHandle.toFileHandle(), aBuffer);
    }

    @Override
    public FileHandle renameFile(FileHandle aFileHandle, String aNewName) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalNameException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileException {
        aFileHandle = FileSystemUtility.toNormalizedFileHandle(aFileHandle, this);
        FileHandle.MutableFileHandle theMutableFileHandle = aFileHandle.toMutableFileHandle();
        theMutableFileHandle.setPath(this.toRealPath(aFileHandle));
        FileHandle theNewFileHandle = this._fileSystem.renameFile(theMutableFileHandle.toFileHandle(), aNewName);
        FileHandle.MutableFileHandle theMutableNewFileHandle = theNewFileHandle.toMutableFileHandle();
        theMutableNewFileHandle.setPath(this.toVirtualPath(theNewFileHandle));
        return theMutableNewFileHandle.toFileHandle();
    }

    @Override
    public FileHandle moveFile(FileHandle aFileHandle, String aNewKey) throws UnknownFileException, ConcurrentAccessException, FileAlreadyExistsException, NoCreateAccessException, NoDeleteAccessException, IllegalKeyException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileException {
        aFileHandle = FileSystemUtility.toNormalizedFileHandle(aFileHandle, this);
        FileHandle.MutableFileHandle theMutableFileHandle = aFileHandle.toMutableFileHandle();
        theMutableFileHandle.setPath(this.toRealPath(aFileHandle));
        aNewKey = this._namespace + PATH_DELIMITER + (String)aNewKey;
        FileHandle theNewFileHandle = this._fileSystem.moveFile(theMutableFileHandle.toFileHandle(), (String)aNewKey);
        FileHandle.MutableFileHandle theMutableNewFileHandle = theNewFileHandle.toMutableFileHandle();
        theMutableNewFileHandle.setPath(this.toVirtualPath(theNewFileHandle));
        return theMutableNewFileHandle.toFileHandle();
    }

    @Override
    public void deleteFile(FileHandle aFileHandle) throws ConcurrentAccessException, UnknownFileException, NoDeleteAccessException, UnknownFileSystemException, IOException, NoListAccessException, IllegalFileException {
        aFileHandle = FileSystemUtility.toNormalizedFileHandle(aFileHandle, this);
        FileHandle.MutableFileHandle theMutableFileHandle = aFileHandle.toMutableFileHandle();
        theMutableFileHandle.setPath(this.toRealPath(aFileHandle));
        this._fileSystem.deleteFile(theMutableFileHandle.toFileHandle());
    }

    @Override
    public boolean hasFiles(String aPath, boolean isRecursively) throws NoListAccessException, IllegalPathException, UnknownFileSystemException, IOException {
        aPath = FileSystemUtility.toNormalizedPath((String)aPath, this);
        aPath = this._namespace + PATH_DELIMITER + (String)aPath;
        return this._fileSystem.hasFiles((String)aPath, isRecursively);
    }

    @Override
    public List<FileHandle> getFileHandles(String aPath, boolean isRecursively) throws NoListAccessException, UnknownPathException, IllegalPathException, UnknownFileSystemException, IOException {
        aPath = FileSystemUtility.toNormalizedPath((String)aPath, this);
        aPath = this._namespace + PATH_DELIMITER + (String)aPath;
        List<FileHandle> theFileHandles = this._fileSystem.getFileHandles((String)aPath, isRecursively);
        ArrayList<FileHandle> theFoundFileHandles = new ArrayList<FileHandle>();
        for (FileHandle eFileHandle : theFileHandles) {
            FileHandle.MutableFileHandle eMutableFileHandle = eFileHandle.toMutableFileHandle();
            eMutableFileHandle.setPath(this.toVirtualPath(eFileHandle));
            theFoundFileHandles.add(eMutableFileHandle.toFileHandle());
        }
        return theFoundFileHandles;
    }

    public void destroy() {
        if (this._fileSystem != null) {
            this._fileSystem.destroy();
        }
    }

    private String toVirtualPath(FileHandle aFileHandle) {
        return aFileHandle.getPath().substring((this._namespace + PATH_DELIMITER).length());
    }

    private String toRealPath(FileHandle aFileHandle) {
        return this._namespace + PATH_DELIMITER + aFileHandle.getPath();
    }
}

