/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.filesystem;

import org.refcodes.exception.AbstractException;
import org.refcodes.filesystem.FileHandle;
import org.refcodes.filesystem.FileHandleAccessor;
import org.refcodes.mixin.KeyAccessor;
import org.refcodes.mixin.NameAccessor;
import org.refcodes.mixin.PathAccessor;

public abstract class FileSystemException
extends AbstractException {
    private static final long serialVersionUID = 1L;

    public FileSystemException(String aMessage, String aErrorCode) {
        super(aMessage, aErrorCode);
    }

    public FileSystemException(String aMessage, Throwable aCause, String aErrorCode) {
        super(aMessage, aCause, aErrorCode);
    }

    public FileSystemException(String aMessage, Throwable aCause) {
        super(aMessage, aCause);
    }

    public FileSystemException(String aMessage) {
        super(aMessage);
    }

    public FileSystemException(Throwable aCause, String aErrorCode) {
        super(aCause, aErrorCode);
    }

    public FileSystemException(Throwable aCause) {
        super(aCause);
    }

    protected static abstract class PathException
    extends FileSystemException
    implements PathAccessor {
        private static final long serialVersionUID = 1L;
        protected String _path;

        public PathException(String aMessage, String aPath, String aErrorCode) {
            super(aMessage, aErrorCode);
            this._path = aPath;
        }

        public PathException(String aMessage, String aPath, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
            this._path = aPath;
        }

        public PathException(String aMessage, String aPath, Throwable aCause) {
            super(aMessage, aCause);
            this._path = aPath;
        }

        public PathException(String aMessage, String aPath) {
            super(aMessage);
            this._path = aPath;
        }

        public PathException(String aPath, Throwable aCause, String aErrorCode) {
            super(aCause, aErrorCode);
            this._path = aPath;
        }

        public PathException(String aPath, Throwable aCause) {
            super(aCause);
            this._path = aPath;
        }

        public String getPath() {
            return this._path;
        }

        public Object[] getPatternArguments() {
            return new Object[]{this._path};
        }
    }

    protected static abstract class NameException
    extends FileSystemException
    implements NameAccessor {
        private static final long serialVersionUID = 1L;
        protected String _name;

        public NameException(String aMessage, String aName, String aErrorCode) {
            super(aMessage, aErrorCode);
            this._name = aName;
        }

        public NameException(String aMessage, String aName, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
            this._name = aName;
        }

        public NameException(String aMessage, String aName, Throwable aCause) {
            super(aMessage, aCause);
            this._name = aName;
        }

        public NameException(String aMessage, String aName) {
            super(aMessage);
            this._name = aName;
        }

        public NameException(Throwable aCause, String aName, String aErrorCode) {
            super(aCause, aErrorCode);
            this._name = aName;
        }

        public NameException(String aName, Throwable aCause) {
            super(aCause);
            this._name = aName;
        }

        public String getName() {
            return this._name;
        }

        public Object[] getPatternArguments() {
            return new Object[]{this._name};
        }
    }

    protected static abstract class KeyException
    extends FileSystemException
    implements KeyAccessor<String> {
        private static final long serialVersionUID = 1L;
        protected String _key;

        public KeyException(String aMessage, String aKey, String aErrorCode) {
            super(aMessage, aErrorCode);
            this._key = aKey;
        }

        public KeyException(String aMessage, String aKey, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
            this._key = aKey;
        }

        public KeyException(String aMessage, String aKey, Throwable aCause) {
            super(aMessage, aCause);
            this._key = aKey;
        }

        public KeyException(String aMessage, String aKey) {
            super(aMessage);
            this._key = aKey;
        }

        public KeyException(String aKey, Throwable aCause, String aErrorCode) {
            super(aCause, aErrorCode);
            this._key = aKey;
        }

        public KeyException(String aKey, Throwable aCause) {
            super(aCause);
            this._key = aKey;
        }

        public String getKey() {
            return this._key;
        }

        public Object[] getPatternArguments() {
            return new Object[]{this._key};
        }
    }

    protected static abstract class NoFileSystemAccessException
    extends FileSystemException {
        private static final long serialVersionUID = 1L;

        public NoFileSystemAccessException(String aMessage, String aErrorCode) {
            super(aMessage, aErrorCode);
        }

        public NoFileSystemAccessException(String aMessage, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
        }

        public NoFileSystemAccessException(String aMessage, Throwable aCause) {
            super(aMessage, aCause);
        }

        public NoFileSystemAccessException(String aMessage) {
            super(aMessage);
        }

        public NoFileSystemAccessException(Throwable aCause, String aErrorCode) {
            super(aCause, aErrorCode);
        }

        public NoFileSystemAccessException(Throwable aCause) {
            super(aCause);
        }
    }

    protected static abstract class FileException
    extends FileSystemException
    implements FileHandleAccessor {
        private static final long serialVersionUID = 1L;
        protected FileHandle _fileHandle;

        public FileException(String aMessage, FileHandle aFileHandle, String aErrorCode) {
            super(aMessage, aErrorCode);
            this._fileHandle = aFileHandle;
        }

        public FileException(String aMessage, FileHandle aFileHandle, Throwable aCause, String aErrorCode) {
            super(aMessage, aCause, aErrorCode);
            this._fileHandle = aFileHandle;
        }

        public FileException(String aMessage, FileHandle aFileHandle, Throwable aCause) {
            super(aMessage, aCause);
            this._fileHandle = aFileHandle;
        }

        public FileException(String aMessage, FileHandle aFileHandle) {
            super(aMessage);
            this._fileHandle = aFileHandle;
        }

        public FileException(FileHandle aFileHandle, Throwable aCause, String aErrorCode) {
            super(aCause, aErrorCode);
            this._fileHandle = aFileHandle;
        }

        public FileException(FileHandle aFileHandle, Throwable aCause) {
            super(aCause);
            this._fileHandle = aFileHandle;
        }

        @Override
        public FileHandle getFileHandle() {
            return this._fileHandle;
        }

        public Object[] getPatternArguments() {
            return new Object[]{this._fileHandle};
        }

        protected static abstract class NoAccessException
        extends FileException {
            private static final long serialVersionUID = 1L;

            public NoAccessException(String aMessage, FileHandle aFileHandle, String aErrorCode) {
                super(aMessage, aFileHandle, aErrorCode);
            }

            public NoAccessException(String aMessage, FileHandle aFileHandle, Throwable aCause, String aErrorCode) {
                super(aMessage, aFileHandle, aCause, aErrorCode);
            }

            public NoAccessException(String aMessage, FileHandle aFileHandle, Throwable aCause) {
                super(aMessage, aFileHandle, aCause);
            }

            public NoAccessException(String aMessage, FileHandle aFileHandle) {
                super(aMessage, aFileHandle);
            }

            public NoAccessException(FileHandle aFileHandle, Throwable aCause, String aErrorCode) {
                super(aFileHandle, aCause, aErrorCode);
            }

            public NoAccessException(FileHandle aFileHandle, Throwable aCause) {
                super(aFileHandle, aCause);
            }
        }
    }
}

