/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import org.junit.Assert;
import org.junit.Test;
import org.refcodes.data.Delimiter;
import org.refcodes.forwardsecrecy.ForwardSecrecyUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;

public class ForwardSecrecyUtilityTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

    @Test
    public void testForwardSecrecyUtility() {
        for (int i = 0; i < 50; ++i) {
            String eCipherUid = ForwardSecrecyUtility.createCipherUid();
            String eCipher = ForwardSecrecyUtility.createCipher();
            Assert.assertEquals((long)eCipherUid.length(), (long)24L);
            Assert.assertEquals((long)eCipher.length(), (long)48L);
            LOGGER.info(eCipherUid + " --> " + eCipher);
            String eEncryptedMockText = eCipherUid + Delimiter.CIPHER_UID_DELIMITER.getChar() + i;
            LOGGER.info(eEncryptedMockText + " = " + (ForwardSecrecyUtility.hasEncryptionPattern((String)eEncryptedMockText) ? "Fits encryped pattern" : "Plain"));
            Assert.assertTrue((boolean)ForwardSecrecyUtility.hasEncryptionPattern((String)eEncryptedMockText));
            String eMockText = eCipherUid + i;
            LOGGER.info(eMockText + " = " + (ForwardSecrecyUtility.hasEncryptionPattern((String)eMockText) ? "Fits encryped pattern" : "Plain"));
            Assert.assertFalse((boolean)ForwardSecrecyUtility.hasEncryptionPattern((String)eMockText));
            eMockText = i + eCipherUid + Delimiter.CIPHER_UID_DELIMITER.getChar();
            LOGGER.info(eMockText + " = " + (ForwardSecrecyUtility.hasEncryptionPattern((String)eMockText) ? "Fits encryped pattern" : "Plain"));
            Assert.assertFalse((boolean)ForwardSecrecyUtility.hasEncryptionPattern((String)eMockText));
        }
    }
}

