/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy.impls;

import org.junit.Assert;
import org.junit.Test;
import org.refcodes.data.Encoding;
import org.refcodes.forwardsecrecy.DecryptionService;
import org.refcodes.forwardsecrecy.EncryptionServer;
import org.refcodes.forwardsecrecy.EncryptionService;
import org.refcodes.forwardsecrecy.impls.DecryptionProviderImpl;
import org.refcodes.forwardsecrecy.impls.EncryptionProviderImpl;
import org.refcodes.forwardsecrecy.impls.InMemoryDecryptionServerImpl;
import org.refcodes.forwardsecrecy.impls.InMemoryEncryptionServerImpl;
import org.refcodes.forwardsecrecy.impls.LoopbackDecryptionServiceImpl;
import org.refcodes.forwardsecrecy.impls.LoopbackEncryptionServiceImpl;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.security.SecurityUtility;

public class ForwardSecrecyTest {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String HALLO_WELT = "Hallo Welt";
    private static final String NAMESPACE = "test";

    @Test
    public void testCryptographyInfrystructure() throws Exception {
        InMemoryDecryptionServerImpl theDecryptionServer = new InMemoryDecryptionServerImpl();
        LoopbackDecryptionServiceImpl theDecryptionService = new LoopbackDecryptionServiceImpl(NAMESPACE, theDecryptionServer);
        theDecryptionService.setCipherVersionsExpireTimeInMs(500L);
        DecryptionProviderImpl theDecryptionProvider = new DecryptionProviderImpl((DecryptionService)theDecryptionService);
        InMemoryEncryptionServerImpl theEncryptionServer = new InMemoryEncryptionServerImpl(theDecryptionServer);
        LoopbackEncryptionServiceImpl theEncryptionService = new LoopbackEncryptionServiceImpl(NAMESPACE, (EncryptionServer)theEncryptionServer);
        EncryptionProviderImpl theEncryptionProvider = new EncryptionProviderImpl((EncryptionService)theEncryptionService);
        String theText = "Hallo Welt!";
        String theEncryptedText = theEncryptionProvider.toEncrypted(theText);
        String theDecryptedText = theDecryptionProvider.toDecrypted(theEncryptedText);
        LOGGER.info(theEncryptedText + " -> " + theDecryptedText);
        Assert.assertEquals((Object)theText, (Object)theDecryptedText);
        theEncryptionProvider.nextCipherVersion();
        String theEncryptedText2 = theEncryptionProvider.toEncrypted(theText);
        String theDecryptedText2 = theDecryptionProvider.toDecrypted(theEncryptedText);
        LOGGER.info(theEncryptedText2 + " -> " + theDecryptedText2);
        Assert.assertEquals((Object)theText, (Object)theDecryptedText2);
        theDecryptedText = theDecryptionProvider.toDecrypted(theEncryptedText);
        LOGGER.info(theEncryptedText + " -> " + theDecryptedText);
        Assert.assertEquals((Object)theText, (Object)theDecryptedText);
        for (int i = 0; i < 50; ++i) {
            theEncryptionProvider.nextCipherVersion();
            String eEncryptedText = theEncryptionProvider.toEncrypted(theText);
            String eDecryptedText = theDecryptionProvider.toDecrypted(theEncryptedText);
            LOGGER.info(eEncryptedText + " -> " + eDecryptedText);
            Assert.assertEquals((Object)theText, (Object)eDecryptedText);
        }
    }

    @Test
    public void testCryptographyProvider() throws Exception {
        InMemoryDecryptionServerImpl theDecryptionServer = new InMemoryDecryptionServerImpl();
        LoopbackDecryptionServiceImpl theDecryptionService = new LoopbackDecryptionServiceImpl(NAMESPACE, theDecryptionServer);
        theDecryptionService.setCipherVersionsExpireTimeInMs(500L);
        DecryptionProviderImpl theDecryptionProvider = new DecryptionProviderImpl((DecryptionService)theDecryptionService);
        InMemoryEncryptionServerImpl theEncryptionServer = new InMemoryEncryptionServerImpl(theDecryptionServer);
        LoopbackEncryptionServiceImpl theEncryptionService = new LoopbackEncryptionServiceImpl(NAMESPACE, (EncryptionServer)theEncryptionServer);
        EncryptionProviderImpl theEncryptionProvider = new EncryptionProviderImpl((EncryptionService)theEncryptionService);
        String theInput = "Hallo Welt!";
        String theEncryptedText1 = theEncryptionProvider.toEncrypted(theInput);
        String theOutputText1 = theDecryptionProvider.toDecrypted(theEncryptedText1);
        LOGGER.info(theEncryptedText1 + " -> " + theOutputText1);
        Assert.assertEquals((Object)theInput, (Object)theOutputText1);
        byte[] theInputHex2 = theInput.getBytes(Encoding.UTF_8.getCode());
        byte[] theEncryptedHex2 = new byte[theEncryptedText1.getBytes(Encoding.UTF_8.getCode()).length];
        theEncryptionProvider.toEncrypted(theInputHex2, 0, theInputHex2.length, theEncryptedHex2, 0);
        String theEncryptedText2 = new String(theEncryptedHex2, Encoding.UTF_8.getCode());
        byte[] theDecryptedHex2 = new byte[theInputHex2.length];
        theDecryptionProvider.toDecrypted(theEncryptedHex2, 0, theEncryptedHex2.length, theDecryptedHex2, 0);
        String theOutputText2 = new String(theDecryptedHex2, Encoding.UTF_8.getCode());
        LOGGER.info(theEncryptedText2 + " -> " + theOutputText2);
        Assert.assertEquals((Object)theInput, (Object)theOutputText2);
    }

    @Test
    public void testSymetricCryptography() throws Exception {
        String theText = HALLO_WELT;
        String theEncryptedText = SecurityUtility.toEncryptedText((String)theText);
        LOGGER.info("\"" + theText + "\" --> \"" + theEncryptedText + "\"");
        String theDecryptedText = SecurityUtility.toDecryptedText((String)theEncryptedText);
        Assert.assertEquals((Object)theText, (Object)theDecryptedText);
        Assert.assertEquals((Object)theDecryptedText, (Object)SecurityUtility.toDecryptedText((String)theEncryptedText));
        String theTestString = "0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 0123456789";
        long theStartTime = System.currentTimeMillis();
        int theRuns = 10000;
        for (int i = 0; i < theRuns; ++i) {
            theEncryptedText = SecurityUtility.toEncryptedText((String)(theTestString + i));
        }
        long theEndTime = System.currentTimeMillis();
        LOGGER.info("SYMETRIC ENCRYPTION:");
        LOGGER.info(theRuns + " / seconds = " + (theEndTime - theStartTime) / 1000L);
        LOGGER.info("1 / milliseconds = " + ((double)theEndTime - (double)theStartTime) / (double)theRuns);
        theStartTime = System.currentTimeMillis();
        for (int i = 0; i < theRuns; ++i) {
            theDecryptedText = SecurityUtility.toDecryptedText((String)theEncryptedText);
        }
        theEndTime = System.currentTimeMillis();
        LOGGER.info("SYMETRIC DECRYPTION:");
        LOGGER.info(theRuns + " / seconds = " + (theEndTime - theStartTime) / 1000L);
        LOGGER.info("1 / milliseconds = " + ((double)theEndTime - (double)theStartTime) / (double)theRuns);
    }
}

