// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.forwardsecrecy;

import org.refcodes.forwardsecrecy.ForwardSecrecyException.ForwardSecrecyUniversalIdException;

/**
 * The Class CipherUidAlreadyInUseException.
 */
public class CipherUidAlreadyInUseException extends ForwardSecrecyUniversalIdException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new cipher Universal-ID already in use exception.
	 *
	 * @param aUid the Universal-ID
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public CipherUidAlreadyInUseException( String aUid, String aMessage, String aErrorCode ) {
		super( aUid, aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new cipher Universal-ID already in use exception.
	 *
	 * @param aUid the Universal-ID
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public CipherUidAlreadyInUseException( String aUid, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aUid, aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new cipher Universal-ID already in use exception.
	 *
	 * @param aUid the Universal-ID
	 * @param message the message
	 * @param cause the cause
	 */
	public CipherUidAlreadyInUseException( String aUid, String message, Throwable cause ) {
		super( aUid, message, cause );
	}

	/**
	 * Instantiates a new cipher Universal-ID already in use exception.
	 *
	 * @param aUid the Universal-ID
	 * @param message the message
	 */
	public CipherUidAlreadyInUseException( String aUid, String message ) {
		super( aUid, message );
	}

	/**
	 * Instantiates a new cipher Universal-ID already in use exception.
	 *
	 * @param aUid the Universal-ID
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public CipherUidAlreadyInUseException( String aUid, Throwable aCause, String aErrorCode ) {
		super( aUid, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new cipher Universal-ID already in use exception.
	 *
	 * @param aUid the Universal-ID
	 * @param cause the cause
	 */
	public CipherUidAlreadyInUseException( String aUid, Throwable cause ) {
		super( aUid, cause );
	}
}
