// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.forwardsecrecy;

import org.refcodes.mixin.UniversalIdAccessor;
import org.refcodes.security.DecryptionException;

/**
 * The Class ForwardSecrecyDecryptionException.
 */
public abstract class ForwardSecrecyDecryptionException extends DecryptionException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new forward secrecy decryption exception.
	 *
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public ForwardSecrecyDecryptionException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new forward secrecy decryption exception.
	 *
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public ForwardSecrecyDecryptionException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new forward secrecy decryption exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public ForwardSecrecyDecryptionException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new forward secrecy decryption exception.
	 *
	 * @param message the message
	 */
	public ForwardSecrecyDecryptionException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new forward secrecy decryption exception.
	 *
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public ForwardSecrecyDecryptionException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new forward secrecy decryption exception.
	 *
	 * @param cause the cause
	 */
	public ForwardSecrecyDecryptionException( Throwable cause ) {
		super( cause );
	}

	/**
	 * The Class ForwardSecrecyDecryptionUniversalIdException.
	 */
	static abstract class ForwardSecrecyDecryptionUniversalIdException extends ForwardSecrecyDecryptionException implements UniversalIdAccessor {

		private static final long serialVersionUID = 1L;

		private String _uId;

		/**
		 * Instantiates a new forward secrecy decryption Universal-ID exception.
		 *
		 * @param aUid the Universal-ID
		 * @param aMessage the message
		 * @param aErrorCode the error code
		 */
		public ForwardSecrecyDecryptionUniversalIdException( String aUid, String aMessage, String aErrorCode ) {
			super( aMessage, aErrorCode );
			_uId = aUid;
		}

		/**
		 * Instantiates a new forward secrecy decryption Universal-ID exception.
		 *
		 * @param aUid the Universal-ID
		 * @param aMessage the message
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public ForwardSecrecyDecryptionUniversalIdException( String aUid, String aMessage, Throwable aCause, String aErrorCode ) {
			super( aMessage, aCause, aErrorCode );
			_uId = aUid;
		}

		/**
		 * Instantiates a new forward secrecy decryption Universal-ID exception.
		 *
		 * @param aUid the Universal-ID
		 * @param message the message
		 * @param cause the cause
		 */
		public ForwardSecrecyDecryptionUniversalIdException( String aUid, String message, Throwable cause ) {
			super( message, cause );
			_uId = aUid;
		}

		/**
		 * Instantiates a new forward secrecy decryption Universal-ID exception.
		 *
		 * @param aUid the Universal-ID
		 * @param message the message
		 */
		public ForwardSecrecyDecryptionUniversalIdException( String aUid, String message ) {
			super( message );
			_uId = aUid;
		}

		/**
		 * Instantiates a new forward secrecy decryption Universal-ID exception.
		 *
		 * @param aUid the Universal-ID
		 * @param aCause the cause
		 * @param aErrorCode the error code
		 */
		public ForwardSecrecyDecryptionUniversalIdException( String aUid, Throwable aCause, String aErrorCode ) {
			super( aCause, aErrorCode );
			_uId = aUid;
		}

		/**
		 * Instantiates a new forward secrecy decryption Universal-ID exception.
		 *
		 * @param aUid the Universal-ID
		 * @param cause the cause
		 */
		public ForwardSecrecyDecryptionUniversalIdException( String aUid, Throwable cause ) {
			super( cause );
			_uId = aUid;
		}

		/**
		 * Gets the Universal-ID.
		 *
		 * @return the Universal-ID
		 */
		@Override
		public String getUniversalId() {
			return _uId;
		}
	}
}
