// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.forwardsecrecy;

import org.refcodes.exception.AbstractRuntimeException;

/**
 * The Class ForwardSecrecyRuntimeException.
 */
public abstract class ForwardSecrecyRuntimeException extends AbstractRuntimeException {

	private static final long serialVersionUID = 1L;

	/**
	 * Instantiates a new forward secrecy runtime exception.
	 *
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public ForwardSecrecyRuntimeException( String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
	}

	/**
	 * Instantiates a new forward secrecy runtime exception.
	 *
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public ForwardSecrecyRuntimeException( String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
	}

	/**
	 * Instantiates a new forward secrecy runtime exception.
	 *
	 * @param message the message
	 * @param cause the cause
	 */
	public ForwardSecrecyRuntimeException( String message, Throwable cause ) {
		super( message, cause );
	}

	/**
	 * Instantiates a new forward secrecy runtime exception.
	 *
	 * @param message the message
	 */
	public ForwardSecrecyRuntimeException( String message ) {
		super( message );
	}

	/**
	 * Instantiates a new forward secrecy runtime exception.
	 *
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public ForwardSecrecyRuntimeException( Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
	}

	/**
	 * Instantiates a new forward secrecy runtime exception.
	 *
	 * @param cause the cause
	 */
	public ForwardSecrecyRuntimeException( Throwable cause ) {
		super( cause );
	}
}
