// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.forwardsecrecy;

/**
 * The {@link InMemoryEncryptionServerImpl} is a non-persisting implementation
 * of the {@link EncryptionServer} managing the {@link CipherVersion} instances
 * in memory only. This implementation provides means to easily set up a quick
 * and dirty test setup. The {@link InMemoryDecryptionServerImpl} is the
 * counterpart of the {@link InMemoryEncryptionServerImpl} which both work (not
 * doing any persistence) hand in hand.
 */
public class InMemoryEncryptionServerImpl implements EncryptionServer {

	private InMemoryDecryptionServerImpl _decryptionServer;

	/**
	 * Constructs the server with the provided decryption server.
	 * 
	 * @param aDecryptionServer The decryption server to be used simulating a
	 *        cipher repository of some kind
	 */
	public InMemoryEncryptionServerImpl( InMemoryDecryptionServerImpl aDecryptionServer ) {
		_decryptionServer = aDecryptionServer;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addCipherVersion( String aNamespace, CipherVersion aCipherVersion ) throws CipherUidAlreadyInUseException {
		_decryptionServer.addCipherVersion( aNamespace, aCipherVersion );
	}
}
