// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.forwardsecrecy;

import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextGenerartorImpl;
import org.refcodes.textual.RandomTextMode;

/**
 * The {@link LoopbackDecryptionServiceImpl} is an UNSECURE implementation of
 * the {@link DecryptionService} managing the ciphers in the
 * {@link CipherVersion} in plan text. This implementation's mere purpose is to
 * provide means to easily set up a quick and dirty test setup. The
 * {@link LoopbackDecryptionServiceImpl} is the counterpart of the
 * {@link LoopbackEncryptionServiceImpl} which both work (insecurely) hand in
 * hand.
 * <p>
 * The {@link LoopbackDecryptionServiceImpl} must not be used in production
 * environments!
 *
 * @deprecated To prevent accidental use in productive environment this insecure
 *             implementation of the {@link DecryptionService} has been marked
 *             as being deprecated; please use only for testing purposes.
 */
@Deprecated
public class LoopbackDecryptionServiceImpl extends AbstractDecryptionService {

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTOR:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 * 
	 * @deprecated To prevent accidental use in productive environment this
	 *             insecure implementation of the {@link DecryptionService} has
	 *             been marked as being deprecated; please use only for testing
	 *             purposes.
	 */
	@Deprecated
	public LoopbackDecryptionServiceImpl( String aNamespace, InMemoryDecryptionServerImpl aDecryptionServer ) {
		super( aNamespace, aDecryptionServer );
	}

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private RandomTextGenerartor _rndTextGenerator = new RandomTextGenerartorImpl().withColumnWidth( 64 ).withRandomTextMode( RandomTextMode.ASCII );

	// /////////////////////////////////////////////////////////////////////////
	// HOOK METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String toSignature( String aMessage ) {
		return aMessage;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected String createMessage() {
		return _rndTextGenerator.next();
	}

	/**
	 * {@inheritDoc}
	 * 
	 * CAUTION: The encrypted {@link CipherVersion} argument is returned
	 * unmodified (not decrypted!). Please overwrite this method with a
	 * decrypting one!
	 * 
	 * @deprecated To prevent accidental use in productive environment this
	 *             insecure implementation of the {@link DecryptionService} has
	 *             been marked as being deprecated; please use only for testing
	 *             purposes.
	 */
	@Deprecated
	@Override
	protected <CV extends CipherVersion> CV toDecryptedCipherVersion( CV aEncryptedCipherVersion ) {
		return aEncryptedCipherVersion;
	}
}