/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import edu.vt.middleware.crypt.asymmetric.PublicKeyUtils;
import edu.vt.middleware.crypt.asymmetric.RSA;
import edu.vt.middleware.crypt.util.Base64Converter;
import edu.vt.middleware.crypt.util.Converter;
import edu.vt.middleware.crypt.util.CryptWriter;
import java.io.File;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ForwardSecrecyWorkshopTest {
    private static final boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String PATH_TO_SERVICE_KEY = "/tmp/rsa-service-key.pem";
    private static final String PATH_TO_SERVICE_PUB_KEY = "/tmp/rsa-service-pub-key.pem";
    private static final String PATH_TO_SERVER_KEY = "/tmp/rsa-server-key.pem";
    private static final String PATH_TO_SERVER_PUB_KEY = "/tmp/rsa-server-pub-key.pem";
    private static final String HALLO_WELT = "Hallo Welt";

    @Disabled(value="As of being a workshop no units are tested. Caution: When enabling, files are written to the FS!")
    @Test
    public void testAsysmetricCryptography() throws Exception {
        KeyPair theServerKeyPair = PublicKeyUtils.generate((String)"RSA", (int)2048);
        KeyPair theServiceKeyPair = PublicKeyUtils.generate((String)"RSA", (int)2048);
        PublicKey theServerPublicKey = theServerKeyPair.getPublic();
        PrivateKey theServerPrivateKey = theServerKeyPair.getPrivate();
        CryptWriter.writePemKey((PrivateKey)theServerKeyPair.getPrivate(), null, (SecureRandom)new SecureRandom(), (File)new File(PATH_TO_SERVER_KEY));
        CryptWriter.writePemKey((PublicKey)theServerKeyPair.getPublic(), (File)new File(PATH_TO_SERVER_PUB_KEY));
        CryptWriter.writePemKey((PrivateKey)theServiceKeyPair.getPrivate(), null, (SecureRandom)new SecureRandom(), (File)new File(PATH_TO_SERVICE_KEY));
        CryptWriter.writePemKey((PublicKey)theServiceKeyPair.getPublic(), (File)new File(PATH_TO_SERVICE_PUB_KEY));
        RSA theEncryptAlgorithm = new RSA();
        theEncryptAlgorithm.setKey((Key)theServerPublicKey);
        theEncryptAlgorithm.initEncrypt();
        RSA theDencryptAlgorithm = new RSA();
        theDencryptAlgorithm.setKey((Key)theServerPrivateKey);
        theDencryptAlgorithm.initDecrypt();
        Base64Converter theBase64Converter = new Base64Converter();
        String theEncryptedText = theEncryptAlgorithm.encrypt(HALLO_WELT.getBytes(), (Converter)theBase64Converter);
        if (IS_LOG_TESTS) {
            System.out.println("Encrypted  = " + theEncryptedText);
        }
        if (IS_LOG_TESTS) {
            System.out.println("Length     = " + theEncryptedText.length());
        }
        String theDecryptedText = new String(theDencryptAlgorithm.decrypt(theEncryptedText, (Converter)theBase64Converter));
        if (IS_LOG_TESTS) {
            System.out.println("Dencrypted = " + theDecryptedText);
        }
        String theTestString = "0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 0123456789";
        long theStartTime = System.currentTimeMillis();
        int theRuns = 1000;
        for (int i = 0; i < theRuns; ++i) {
            theEncryptedText = theEncryptAlgorithm.encrypt((theTestString + i).getBytes(), (Converter)theBase64Converter);
        }
        long theEndTime = System.currentTimeMillis();
        if (IS_LOG_TESTS) {
            System.out.println("ASYMETRIC ENCRYPTION:");
        }
        if (IS_LOG_TESTS) {
            System.out.println(theRuns + " / seconds = " + (theEndTime - theStartTime) / 1000L);
        }
        if (IS_LOG_TESTS) {
            System.out.println("1 / milliseconds = " + ((double)theEndTime - (double)theStartTime) / (double)theRuns);
        }
        theStartTime = System.currentTimeMillis();
        for (int i = 0; i < theRuns; ++i) {
            theDecryptedText = new String(theDencryptAlgorithm.decrypt(theEncryptedText, (Converter)theBase64Converter));
        }
        theEndTime = System.currentTimeMillis();
        if (IS_LOG_TESTS) {
            System.out.println("ASYMETRIC DECRYPTION:");
        }
        if (IS_LOG_TESTS) {
            System.out.println(theRuns + " / seconds = " + (theEndTime - theStartTime) / 1000L);
        }
        if (IS_LOG_TESTS) {
            System.out.println("1 / milliseconds = " + ((double)theEndTime - (double)theStartTime) / (double)theRuns);
        }
    }
}

