/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Encoding;
import org.refcodes.forwardsecrecy.DecryptionProviderImpl;
import org.refcodes.forwardsecrecy.DecryptionService;
import org.refcodes.forwardsecrecy.EncryptionProviderImpl;
import org.refcodes.forwardsecrecy.EncryptionServer;
import org.refcodes.forwardsecrecy.EncryptionService;
import org.refcodes.forwardsecrecy.InMemoryDecryptionServerImpl;
import org.refcodes.forwardsecrecy.InMemoryEncryptionServerImpl;
import org.refcodes.forwardsecrecy.LoopbackDecryptionServiceImpl;
import org.refcodes.forwardsecrecy.LoopbackEncryptionServiceImpl;
import org.refcodes.security.SecurityUtility;

public class ForwardSecrecyTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");
    private static final String HALLO_WELT = "Hallo Welt";
    private static final String NAMESPACE = "test";

    @Test
    public void testCryptographyInfrystructure() throws Exception {
        InMemoryDecryptionServerImpl theDecryptionServer = new InMemoryDecryptionServerImpl();
        LoopbackDecryptionServiceImpl theDecryptionService = new LoopbackDecryptionServiceImpl(NAMESPACE, theDecryptionServer);
        theDecryptionService.setCipherVersionsExpireTimeInMs(500L);
        DecryptionProviderImpl theDecryptionProvider = new DecryptionProviderImpl((DecryptionService)theDecryptionService);
        InMemoryEncryptionServerImpl theEncryptionServer = new InMemoryEncryptionServerImpl(theDecryptionServer);
        LoopbackEncryptionServiceImpl theEncryptionService = new LoopbackEncryptionServiceImpl(NAMESPACE, (EncryptionServer)theEncryptionServer);
        EncryptionProviderImpl theEncryptionProvider = new EncryptionProviderImpl((EncryptionService)theEncryptionService);
        String theText = "Hallo Welt!";
        String theEncryptedText = theEncryptionProvider.toEncrypted(theText);
        String theDecryptedText = theDecryptionProvider.toDecrypted(theEncryptedText);
        if (IS_LOG_TESTS) {
            System.out.println(theEncryptedText + " -> " + theDecryptedText);
        }
        Assertions.assertEquals((Object)theText, (Object)theDecryptedText);
        theEncryptionProvider.nextCipherVersion();
        String theEncryptedText2 = theEncryptionProvider.toEncrypted(theText);
        String theDecryptedText2 = theDecryptionProvider.toDecrypted(theEncryptedText);
        if (IS_LOG_TESTS) {
            System.out.println(theEncryptedText2 + " -> " + theDecryptedText2);
        }
        Assertions.assertEquals((Object)theText, (Object)theDecryptedText2);
        theDecryptedText = theDecryptionProvider.toDecrypted(theEncryptedText);
        if (IS_LOG_TESTS) {
            System.out.println(theEncryptedText + " -> " + theDecryptedText);
        }
        Assertions.assertEquals((Object)theText, (Object)theDecryptedText);
        for (int i = 0; i < 50; ++i) {
            theEncryptionProvider.nextCipherVersion();
            String eEncryptedText = theEncryptionProvider.toEncrypted(theText);
            String eDecryptedText = theDecryptionProvider.toDecrypted(theEncryptedText);
            if (IS_LOG_TESTS) {
                System.out.println(eEncryptedText + " -> " + eDecryptedText);
            }
            Assertions.assertEquals((Object)theText, (Object)eDecryptedText);
        }
    }

    @Test
    public void testCryptographyProvider() throws Exception {
        InMemoryDecryptionServerImpl theDecryptionServer = new InMemoryDecryptionServerImpl();
        LoopbackDecryptionServiceImpl theDecryptionService = new LoopbackDecryptionServiceImpl(NAMESPACE, theDecryptionServer);
        theDecryptionService.setCipherVersionsExpireTimeInMs(500L);
        DecryptionProviderImpl theDecryptionProvider = new DecryptionProviderImpl((DecryptionService)theDecryptionService);
        InMemoryEncryptionServerImpl theEncryptionServer = new InMemoryEncryptionServerImpl(theDecryptionServer);
        LoopbackEncryptionServiceImpl theEncryptionService = new LoopbackEncryptionServiceImpl(NAMESPACE, (EncryptionServer)theEncryptionServer);
        EncryptionProviderImpl theEncryptionProvider = new EncryptionProviderImpl((EncryptionService)theEncryptionService);
        String theInput = "Hallo Welt!";
        String theEncryptedText1 = theEncryptionProvider.toEncrypted(theInput);
        String theOutputText1 = theDecryptionProvider.toDecrypted(theEncryptedText1);
        if (IS_LOG_TESTS) {
            System.out.println(theEncryptedText1 + " -> " + theOutputText1);
        }
        Assertions.assertEquals((Object)theInput, (Object)theOutputText1);
        byte[] theInputHex2 = theInput.getBytes(Encoding.UTF_8.getCode());
        byte[] theEncryptedHex2 = new byte[theEncryptedText1.getBytes(Encoding.UTF_8.getCode()).length];
        theEncryptionProvider.toEncrypted(theInputHex2, 0, theInputHex2.length, theEncryptedHex2, 0);
        String theEncryptedText2 = new String(theEncryptedHex2, Encoding.UTF_8.getCode());
        byte[] theDecryptedHex2 = new byte[theInputHex2.length];
        theDecryptionProvider.toDecrypted(theEncryptedHex2, 0, theEncryptedHex2.length, theDecryptedHex2, 0);
        String theOutputText2 = new String(theDecryptedHex2, Encoding.UTF_8.getCode());
        if (IS_LOG_TESTS) {
            System.out.println(theEncryptedText2 + " -> " + theOutputText2);
        }
        Assertions.assertEquals((Object)theInput, (Object)theOutputText2);
    }

    @Test
    public void testSymetricCryptography() throws Exception {
        String theText = HALLO_WELT;
        String theEncryptedText = SecurityUtility.toEncryptedText((String)theText);
        if (IS_LOG_TESTS) {
            System.out.println("\"" + theText + "\" --> \"" + theEncryptedText + "\"");
        }
        String theDecryptedText = SecurityUtility.toDecryptedText((String)theEncryptedText);
        Assertions.assertEquals((Object)theText, (Object)theDecryptedText);
        Assertions.assertEquals((Object)theDecryptedText, (Object)SecurityUtility.toDecryptedText((String)theEncryptedText));
        String theTestString = "0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 0123456789";
        long theStartTime = System.currentTimeMillis();
        int theRuns = 10000;
        for (int i = 0; i < theRuns; ++i) {
            theEncryptedText = SecurityUtility.toEncryptedText((String)(theTestString + i));
        }
        long theEndTime = System.currentTimeMillis();
        if (IS_LOG_TESTS) {
            System.out.println("SYMETRIC ENCRYPTION:");
        }
        if (IS_LOG_TESTS) {
            System.out.println(theRuns + " / seconds = " + (theEndTime - theStartTime) / 1000L);
        }
        if (IS_LOG_TESTS) {
            System.out.println("1 / milliseconds = " + ((double)theEndTime - (double)theStartTime) / (double)theRuns);
        }
        theStartTime = System.currentTimeMillis();
        for (int i = 0; i < theRuns; ++i) {
            theDecryptedText = SecurityUtility.toDecryptedText((String)theEncryptedText);
        }
        theEndTime = System.currentTimeMillis();
        if (IS_LOG_TESTS) {
            System.out.println("SYMETRIC DECRYPTION:");
        }
        if (IS_LOG_TESTS) {
            System.out.println(theRuns + " / seconds = " + (theEndTime - theStartTime) / 1000L);
        }
        if (IS_LOG_TESTS) {
            System.out.println("1 / milliseconds = " + ((double)theEndTime - (double)theStartTime) / (double)theRuns);
        }
    }
}

