/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Delimiter;
import org.refcodes.forwardsecrecy.ForwardSecrecyUtility;

public class ForwardSecrecyUtilityTest {
    private static boolean IS_LOG_TESTS = Boolean.getBoolean("log.tests");

    @Test
    public void testForwardSecrecyUtility() {
        for (int i = 0; i < 50; ++i) {
            String eCipherUid = ForwardSecrecyUtility.createCipherUid();
            String eCipher = ForwardSecrecyUtility.createCipher();
            Assertions.assertEquals((int)eCipherUid.length(), (int)24);
            Assertions.assertEquals((int)eCipher.length(), (int)48);
            if (IS_LOG_TESTS) {
                System.out.println(eCipherUid + " --> " + eCipher);
            }
            String eEncryptedMockText = eCipherUid + Delimiter.CIPHER_UID.getChar() + i;
            if (IS_LOG_TESTS) {
                System.out.println(eEncryptedMockText + " = " + (ForwardSecrecyUtility.hasEncryptionPattern((String)eEncryptedMockText) ? "Fits encryped pattern" : "Plain"));
            }
            Assertions.assertTrue((boolean)ForwardSecrecyUtility.hasEncryptionPattern((String)eEncryptedMockText));
            String eMockText = eCipherUid + i;
            if (IS_LOG_TESTS) {
                System.out.println(eMockText + " = " + (ForwardSecrecyUtility.hasEncryptionPattern((String)eMockText) ? "Fits encryped pattern" : "Plain"));
            }
            Assertions.assertFalse((boolean)ForwardSecrecyUtility.hasEncryptionPattern((String)eMockText));
            eMockText = i + eCipherUid + Delimiter.CIPHER_UID.getChar();
            if (IS_LOG_TESTS) {
                System.out.println(eMockText + " = " + (ForwardSecrecyUtility.hasEncryptionPattern((String)eMockText) ? "Fits encryped pattern" : "Plain"));
            }
            Assertions.assertFalse((boolean)ForwardSecrecyUtility.hasEncryptionPattern((String)eMockText));
        }
    }
}

