/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.exception.HiddenException;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.DecryptionServer;
import org.refcodes.forwardsecrecy.DecryptionService;
import org.refcodes.forwardsecrecy.SignatureVerificationException;

public abstract class AbstractDecryptionService
implements DecryptionService {
    private static long EXPIRE_TIME_NEVER = -1L;
    private static long EXPIRE_TIME_IMMEDIAGTELY = 0L;
    private DecryptionServer _decryptionServer;
    private String _namespace;
    private long _cipherVersionsExpireTimeInMs;
    private long _cipherVersionsLastLoadedTime = EXPIRE_TIME_IMMEDIAGTELY;
    private List<CipherVersion> _cipherVersions;

    public AbstractDecryptionService(String aNamespace, DecryptionServer aDecryptionServer) {
        this._namespace = aNamespace;
        this._decryptionServer = aDecryptionServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CipherVersion> getCipherVersions() {
        if (this._cipherVersionsExpireTimeInMs == EXPIRE_TIME_NEVER && this._cipherVersions != null) {
            return this._cipherVersions;
        }
        long theCurrentTimeMs = System.currentTimeMillis();
        if (this.isLoadEncryptedCipherVersions(theCurrentTimeMs)) {
            AbstractDecryptionService abstractDecryptionService = this;
            synchronized (abstractDecryptionService) {
                if (this.isLoadEncryptedCipherVersions(theCurrentTimeMs)) {
                    List<CipherVersion> theEncryptedCipherVersions;
                    try {
                        String theMessage = this.createMessage();
                        String theSignature = this.toSignature(theMessage);
                        theEncryptedCipherVersions = this._decryptionServer.getCipherVersions(this._namespace, theMessage, theSignature);
                    }
                    catch (SignatureVerificationException e) {
                        throw new HiddenException((Throwable)((Object)e));
                    }
                    ArrayList<CipherVersion> theCipherVersions = new ArrayList<CipherVersion>();
                    for (CipherVersion eCipherVersion : theEncryptedCipherVersions) {
                        theCipherVersions.add(this.toDecryptedCipherVersion(eCipherVersion));
                    }
                    this._cipherVersions = theCipherVersions;
                    this._cipherVersionsLastLoadedTime = System.currentTimeMillis();
                }
            }
        }
        return this._cipherVersions;
    }

    private boolean isLoadEncryptedCipherVersions(long aCurrentTimeMillis) {
        return this._cipherVersionsExpireTimeInMs == EXPIRE_TIME_IMMEDIAGTELY || this._cipherVersions == null || this._cipherVersionsExpireTimeInMs > 0L && aCurrentTimeMillis - this._cipherVersionsExpireTimeInMs > this._cipherVersionsLastLoadedTime;
    }

    public void setCipherVersionsExpireTimeInMs(long aCipherVersionsExpireTimeInMs) {
        this._cipherVersionsExpireTimeInMs = aCipherVersionsExpireTimeInMs;
    }

    protected abstract String toSignature(String var1);

    protected abstract String createMessage();

    protected abstract <CV extends CipherVersion> CV toDecryptedCipherVersion(CV var1);
}

