/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import org.refcodes.controlflow.RetryCounterImpl;
import org.refcodes.data.LoopSleepTime;
import org.refcodes.data.RetryCount;
import org.refcodes.data.Text;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.forwardsecrecy.CipherUidAlreadyInUseException;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.CipherVersionGenerator;
import org.refcodes.forwardsecrecy.EncryptionServer;
import org.refcodes.forwardsecrecy.EncryptionService;
import org.refcodes.forwardsecrecy.UnexpectedForwardSecrecyRuntimeException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public abstract class AbstractEncryptionService
implements EncryptionService {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private CipherVersionGenerator<CipherVersion> _cipherVersionGenerator;
    private String _namespace;
    private EncryptionServer _encryptionServer;

    public AbstractEncryptionService(String aNamespace, EncryptionServer aEncryptionServer, CipherVersionGenerator<CipherVersion> aCipherVersionGenerator) {
        this._cipherVersionGenerator = aCipherVersionGenerator;
        this._encryptionServer = aEncryptionServer;
        this._namespace = aNamespace;
    }

    @Override
    public CipherVersion next() {
        Object eCipherVersion = null;
        RetryCounterImpl theRetryCounter = new RetryCounterImpl(RetryCount.NORM.getValue().intValue(), (long)LoopSleepTime.MIN.getMillis());
        while (theRetryCounter.nextRetry()) {
            try {
                eCipherVersion = this._cipherVersionGenerator.next();
                this._encryptionServer.addCipherVersion(this._namespace, (CipherVersion)this.toEncryptedCipherVersion(eCipherVersion));
                return eCipherVersion;
            }
            catch (CipherUidAlreadyInUseException e) {
                if (theRetryCounter.hasNextRetry()) continue;
                LOGGER.warn("Failed to add a cipher UID \"" + eCipherVersion.getUniversalId() + "\", retry count is <" + theRetryCounter.getRetryCount() + "> of <" + theRetryCounter.getRetryNumber() + "> (waiting for <" + theRetryCounter.getNextRetryDelayInMs() / 1000L + "> seconds before next retry): \"" + ExceptionUtility.toMessage((Throwable)((Object)e)) + "\"");
            }
        }
        throw new UnexpectedForwardSecrecyRuntimeException("Unable to generate a Chipher-Version within <" + theRetryCounter.getRetryNumber() + "> tries, aborting as else we might loop infinte time!");
    }

    public boolean hasNext() {
        return true;
    }

    public void remove() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    protected abstract <CV extends CipherVersion> CV toEncryptedCipherVersion(CV var1);
}

