/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.PublicKeyFactory;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.jasypt.util.text.BasicTextEncryptor;
import org.refcodes.data.Delimiter;
import org.refcodes.data.License;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;
import org.refcodes.security.Algorithm;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextBuilderImpl;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextGenerartorImpl;
import org.refcodes.textual.RandomTextMode;

public final class ForwardSecrecyUtility {
    private static final char CIPHER_UID_TIMESTAMP_SEPARATOR = '-';
    public static final int CIPHER_UID_TIMESTAMP_LENGTH = 14;
    public static final int CIPHER_UID_LENGTH = 24;
    public static final int CIPHER_LENGTH = 48;
    public static final int MESSAGE_LENGTH = 256;
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static BasicTextEncryptor TEXT_ENCRYPTOR;
    private static RandomTextGenerartor RND_CIPHER_GENERATOR;
    private static RandomTextGenerartor RND_MESSAGE_GENERATOR;
    private static final String BOUNCY_CASTLE_PROVIDER = "BC";

    private ForwardSecrecyUtility() {
    }

    public static boolean hasEncryptionPattern(String aText) {
        if (aText.length() < 24) {
            return false;
        }
        if (aText.charAt(24) != Delimiter.CIPHER_UID.getChar()) {
            return false;
        }
        return aText.charAt(13) == '-';
    }

    public static String toCipherUidPrefix(String aCipherUidWithEncryptedText) {
        int theIndex = aCipherUidWithEncryptedText.indexOf(Delimiter.CIPHER_UID.getChar());
        if (theIndex == -1) {
            return null;
        }
        return aCipherUidWithEncryptedText.substring(0, theIndex);
    }

    public static String toEncryptedTextBody(String aCipherUidWithEncryptedText) {
        int theIndex = aCipherUidWithEncryptedText.indexOf(Delimiter.CIPHER_UID.getChar());
        if (theIndex == -1) {
            return null;
        }
        return aCipherUidWithEncryptedText.substring(theIndex + 1);
    }

    public static String createCipherUid() {
        Object theCipherUid = System.currentTimeMillis() + "-";
        theCipherUid = ((HorizAlignTextBuilder)((HorizAlignTextBuilder)new HorizAlignTextBuilderImpl().withHorizAlignTextMode(HorizAlignTextMode.RIGHT).withText(new String[]{theCipherUid})).withColumnWidth(14)).withFillChar('0').toString();
        theCipherUid = (String)theCipherUid + (String)new RandomTextGenerartorImpl().withColumnWidth(24 - ((String)theCipherUid).length()).withRandomTextMode(RandomTextMode.ALPHANUMERIC).next();
        return theCipherUid;
    }

    public static String createCipher() {
        return (String)RND_CIPHER_GENERATOR.next();
    }

    public static String createMessage() {
        return (String)RND_MESSAGE_GENERATOR.next();
    }

    public static PrivateKey readPrivateKey(File aFile, String aPassword) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        FileInputStream res = new FileInputStream(aFile);
        Throwable throwable = null;
        try (BufferedReader theReader = new BufferedReader(new InputStreamReader(res));){
            PrivateKey privateKey;
            PEMParser theParser = new PEMParser((Reader)theReader);
            Throwable throwable2 = null;
            try {
                PrivateKey thePrivateKey;
                PEMKeyPair theKeyPair = null;
                if (aPassword != null) {
                    Object eObj;
                    PEMDecryptorProvider theDecryptorProvider = new JcePEMDecryptorProviderBuilder().setProvider(BOUNCY_CASTLE_PROVIDER).build(aPassword.toCharArray());
                    IOException theIoException = null;
                    while ((eObj = theParser.readObject()) != null) {
                        if (!(eObj instanceof PEMEncryptedKeyPair)) continue;
                        try {
                            theKeyPair = ((PEMEncryptedKeyPair)eObj).decryptKeyPair(theDecryptorProvider);
                            break;
                        }
                        catch (IOException e) {
                            if (theIoException != null) continue;
                            theIoException = e;
                        }
                    }
                    if (theKeyPair == null) {
                        if (theIoException != null) {
                            throw theIoException;
                        }
                        throw new IOException("No key-pair found in file <" + aFile.getAbsolutePath() + ">.");
                    }
                } else {
                    Object eObj;
                    while ((eObj = theParser.readObject()) != null) {
                        if (!(eObj instanceof PEMKeyPair)) continue;
                        theKeyPair = (PEMKeyPair)eObj;
                        break;
                    }
                    if (theKeyPair == null) {
                        throw new IOException("No key-pair found in file <" + aFile.getAbsolutePath() + ">.");
                    }
                }
                PKCS8EncodedKeySpec theKeySpec = new PKCS8EncodedKeySpec(theKeyPair.getPrivateKeyInfo().getEncoded());
                KeyFactory theKeyFactory = KeyFactory.getInstance(Algorithm.RSA.getName());
                privateKey = thePrivateKey = theKeyFactory.generatePrivate(theKeySpec);
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ForwardSecrecyUtility.$closeResource(throwable2, (AutoCloseable)theParser);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            ForwardSecrecyUtility.$closeResource(throwable2, (AutoCloseable)theParser);
            return privateKey;
        }
    }

    public static PublicKey readPublicKey(File aFile) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        block14: {
            try (BufferedReader theReader = new BufferedReader(new InputStreamReader(new FileInputStream(aFile)));){
                PublicKey publicKey;
                try (PEMParser theParser = new PEMParser((Reader)theReader);){
                    PublicKey thePublicKey;
                    Object eObj;
                    PEMKeyPair theKeyPair = null;
                    do {
                        PublicKey thePublicKey2;
                        if ((eObj = theParser.readObject()) == null) break block14;
                        if (!(eObj instanceof PEMKeyPair)) continue;
                        theKeyPair = (PEMKeyPair)eObj;
                        PKCS8EncodedKeySpec theKeySpec = new PKCS8EncodedKeySpec(theKeyPair.getPrivateKeyInfo().getEncoded());
                        KeyFactory theKeyFactory = KeyFactory.getInstance(Algorithm.RSA.getName());
                        PublicKey publicKey2 = thePublicKey2 = theKeyFactory.generatePublic(theKeySpec);
                        return publicKey2;
                    } while (!(eObj instanceof SubjectPublicKeyInfo));
                    SubjectPublicKeyInfo eInfo = (SubjectPublicKeyInfo)eObj;
                    RSAKeyParameters theRsaParam = (RSAKeyParameters)PublicKeyFactory.createKey((byte[])eInfo.getEncoded());
                    RSAPublicKeySpec theRsaSpec = new RSAPublicKeySpec(theRsaParam.getModulus(), theRsaParam.getExponent());
                    KeyFactory theKeyFactory = KeyFactory.getInstance(Algorithm.RSA.getName());
                    publicKey = thePublicKey = theKeyFactory.generatePublic(theRsaSpec);
                }
                return publicKey;
            }
        }
        throw new IOException("No key-pair found in file <" + aFile.getAbsolutePath() + ">.");
    }

    static {
        RND_CIPHER_GENERATOR = new RandomTextGenerartorImpl().withColumnWidth(48).withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        RND_MESSAGE_GENERATOR = new RandomTextGenerartorImpl().withColumnWidth(256).withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        Object thePassPhrase = null;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface eNetworkInterface = e.nextElement();
                try {
                    byte[] eHardwareAddress = eNetworkInterface.getHardwareAddress();
                    if (eHardwareAddress == null) continue;
                    thePassPhrase = "";
                    for (int i = 0; i < eHardwareAddress.length; ++i) {
                        thePassPhrase = (String)thePassPhrase + (eHardwareAddress[i] < 0 ? "" + (eHardwareAddress[i] & 0xFF) : "" + eHardwareAddress[i]);
                        if (i >= eHardwareAddress.length - 1) continue;
                        thePassPhrase = (String)thePassPhrase + ".";
                    }
                    break;
                }
                catch (SocketException se) {
                    LOGGER.warn("Unable to acquire network interfaces's (\"" + eNetworkInterface.getDisplayName() + "\") hardware address, trying next network interface.", (Throwable)se);
                }
            }
        }
        catch (SocketException se) {
            LOGGER.warn("Unable to acquire machine's network interfaces (using alternate cipher).", (Throwable)se);
        }
        if (thePassPhrase == null) {
            thePassPhrase = License.REFCODES_LICENSE.getText();
        }
        TEXT_ENCRYPTOR = new BasicTextEncryptor();
        TEXT_ENCRYPTOR.setPassword((String)thePassPhrase);
    }
}

