/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.refcodes.forwardsecrecy.CipherUidAlreadyInUseException;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.CipherVersionFactory;
import org.refcodes.forwardsecrecy.CipherVersionFactoryImpl;
import org.refcodes.forwardsecrecy.DecryptionServer;

public class InMemoryDecryptionServer
implements DecryptionServer {
    private Map<String, List<CipherVersion>> _namespaceToCipherVersions = new HashMap<String, List<CipherVersion>>();
    private CipherVersionFactory<CipherVersion> _cipherVersionFactory = new CipherVersionFactoryImpl();

    @Override
    public List<CipherVersion> getCipherVersions(String aNamespace, String aMessage, String aSignature) {
        return this.getCipherVersions(aNamespace);
    }

    protected void addCipherVersion(String aNamespace, CipherVersion aCipherVersion) throws CipherUidAlreadyInUseException {
        CipherVersion theCipherVersion;
        List<CipherVersion> theCipherVersions = this.getCipherVersions(aNamespace);
        if (theCipherVersions.contains(theCipherVersion = this._cipherVersionFactory.createInstance(aCipherVersion.getUniversalId(), aCipherVersion.getCipher()))) {
            throw new CipherUidAlreadyInUseException(theCipherVersion.getUniversalId(), "A cipher version with the UID \"" + theCipherVersion.getUniversalId() + "\" is already in use!");
        }
        theCipherVersions.add(theCipherVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CipherVersion> getCipherVersions(String aNameSsace) {
        List<CipherVersion> theCipherVersions = this._namespaceToCipherVersions.get(aNameSsace);
        if (theCipherVersions == null) {
            InMemoryDecryptionServer inMemoryDecryptionServer = this;
            synchronized (inMemoryDecryptionServer) {
                theCipherVersions = this._namespaceToCipherVersions.get(aNameSsace);
                if (theCipherVersions == null) {
                    theCipherVersions = new ArrayList<CipherVersion>();
                    this._namespaceToCipherVersions.put(aNameSsace, theCipherVersions);
                }
            }
        }
        return theCipherVersions;
    }
}

