/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.asymmetric.AsymmetricAlgorithm;
import edu.vt.middleware.crypt.asymmetric.RSA;
import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.digest.SHA512;
import edu.vt.middleware.crypt.signature.RSASignature;
import edu.vt.middleware.crypt.signature.SignatureAlgorithm;
import edu.vt.middleware.crypt.util.Base64Converter;
import edu.vt.middleware.crypt.util.Converter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.CipherVersionFactory;
import org.refcodes.forwardsecrecy.CipherVersionFactoryImpl;
import org.refcodes.forwardsecrecy.DecryptionServer;
import org.refcodes.forwardsecrecy.ForwardSecrecyUtility;
import org.refcodes.forwardsecrecy.SignatureVerificationException;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public class PublicKeyDecryptionServerWrapper
implements DecryptionServer {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private static final String KEY_FILE_NAME_CONTAINS = "pub";
    private static final String KEY_FILE_NAME_SUFFIX = ".pem";
    private CipherVersionFactory<CipherVersion> _cipherVersionFactory;
    private Map<SignatureAlgorithm, AsymmetricAlgorithm> _signatureAlgorithmToEncryptAlgorithms = new HashMap<SignatureAlgorithm, AsymmetricAlgorithm>();
    private DecryptionServer _decryptionServer;
    private AsymmetricAlgorithm _decryptAlgorithm;
    private Base64Converter _base64Converter;
    private Map<SignatureAlgorithm, String> _signatureAlgorithmToPublicKeyPath = new HashMap<SignatureAlgorithm, String>();
    private String _privateKeyPath;

    public PublicKeyDecryptionServerWrapper(String aPrivateKeyPath, String aPublicKeysPath, DecryptionServer aDecryptionServer, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws CryptException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        this(aPrivateKeyPath, null, aPublicKeysPath, aDecryptionServer, aCipherVersionFactory);
    }

    public PublicKeyDecryptionServerWrapper(String aPrivateKeyPath, String aPublicKeysPath, DecryptionServer aDecryptionServer) throws CryptException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        this(aPrivateKeyPath, null, aPublicKeysPath, aDecryptionServer, new CipherVersionFactoryImpl());
    }

    public PublicKeyDecryptionServerWrapper(String aPrivateKeyPath, String aPrivateKeyPassPhrase, String aPublicKeysPath, DecryptionServer aDecryptionServer) throws CryptException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        this(aPrivateKeyPath, aPrivateKeyPassPhrase, aPublicKeysPath, aDecryptionServer, new CipherVersionFactoryImpl());
    }

    public PublicKeyDecryptionServerWrapper(String aPrivateKeyPath, String aPrivateKeyPassPhrase, String aPublicKeysPath, DecryptionServer aDecryptionServer, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws CryptException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        this._cipherVersionFactory = aCipherVersionFactory;
        this._privateKeyPath = aPrivateKeyPath;
        this._decryptionServer = aDecryptionServer;
        File thePrivateKeyFile = new File(aPrivateKeyPath);
        LOGGER.debug("Loading private key from file \"" + thePrivateKeyFile.getAbsolutePath() + "\"...");
        try {
            PrivateKey thePrivateKey = ForwardSecrecyUtility.readPrivateKey(thePrivateKeyFile, aPrivateKeyPassPhrase);
            this._decryptAlgorithm = new RSA();
            this._base64Converter = new Base64Converter();
            this._decryptAlgorithm.setKey((Key)thePrivateKey);
            this._decryptAlgorithm.initDecrypt();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Unable to load private key from file \"" + thePrivateKeyFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
        catch (CryptException e) {
            LOGGER.warn("Unable to load private key from file \"" + thePrivateKeyFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
        File thePublicKeysFile = new File(aPublicKeysPath);
        LOGGER.debug("Loading public keys from directory \"" + thePublicKeysFile.getAbsolutePath() + "\"...");
        try {
            if (!thePublicKeysFile.isDirectory()) {
                String theMessage = "No directory found for path  \"" + thePublicKeysFile.getAbsolutePath() + "\", though a directory is required!";
                IOException e = new IOException(theMessage);
                LOGGER.error(theMessage, (Throwable)e);
                throw e;
            }
            for (File ePublicKeyFile : thePublicKeysFile.listFiles()) {
                String eFileName = ePublicKeyFile.getName();
                if (eFileName != null && eFileName.toLowerCase().endsWith(KEY_FILE_NAME_SUFFIX) && eFileName.toLowerCase().indexOf(KEY_FILE_NAME_CONTAINS) != -1) {
                    try {
                        LOGGER.debug("Loading public key from file \"" + ePublicKeyFile.getAbsolutePath() + "\"...");
                        PublicKey ePublicKey = ForwardSecrecyUtility.readPublicKey(ePublicKeyFile);
                        RSA eEncryptAlgorithm = new RSA();
                        eEncryptAlgorithm.setKey((Key)ePublicKey);
                        eEncryptAlgorithm.initEncrypt();
                        RSASignature eSignatureAlgorithm = new RSASignature((DigestAlgorithm)new SHA512());
                        eSignatureAlgorithm.setVerifyKey(ePublicKey);
                        eSignatureAlgorithm.initVerify();
                        this._signatureAlgorithmToEncryptAlgorithms.put((SignatureAlgorithm)eSignatureAlgorithm, (AsymmetricAlgorithm)eEncryptAlgorithm);
                        this._signatureAlgorithmToPublicKeyPath.put((SignatureAlgorithm)eSignatureAlgorithm, ePublicKeyFile.getAbsolutePath());
                        continue;
                    }
                    catch (CryptException e) {
                        LOGGER.warn("Unable to load public key from file \"" + ePublicKeyFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e));
                        throw e;
                    }
                }
                LOGGER.debug("Ignoring non public key file \"" + ePublicKeyFile.getAbsolutePath() + "\" as it neither ends with \".pem\" nor it contains \"pub\" in its filename.");
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Unable to load private keys from folder \"" + thePublicKeysFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
    }

    @Override
    public List<CipherVersion> getCipherVersions(String aNamespace, String aMessage, String aSignature) throws SignatureVerificationException {
        try {
            AsymmetricAlgorithm theEncryptAlgorithm = this.getEncryptAlgorithm(aMessage, aSignature);
            if (theEncryptAlgorithm == null) {
                throw new SignatureVerificationException("Unable to verify the signature for the message \"" + aMessage + "\" for namespace \"" + aNamespace + "\"!");
            }
            List<CipherVersion> theCipherVersionsFromServer = this._decryptionServer.getCipherVersions(aNamespace, aMessage, aSignature);
            ArrayList<CipherVersion> theCipherVersionsToService = new ArrayList<CipherVersion>();
            LOGGER.debug("Using private key \"" + this._privateKeyPath + "\" for decrypting a cipher, previously fetched public key encrypts afterwards ...");
            for (CipherVersion eCipherVersion : theCipherVersionsFromServer) {
                String eDecryptedCipher = new String(this._decryptAlgorithm.decrypt(eCipherVersion.getCipher(), (Converter)this._base64Converter));
                String eEncryptedCipher = new String(theEncryptAlgorithm.encrypt(eDecryptedCipher.getBytes(), (Converter)this._base64Converter));
                eCipherVersion = this._cipherVersionFactory.createInstance(eCipherVersion.getUniversalId(), eEncryptedCipher);
                theCipherVersionsToService.add(eCipherVersion);
            }
            return theCipherVersionsToService;
        }
        catch (CryptException e) {
            throw new SignatureVerificationException("Unable to verify the signature for the message \"" + aMessage + "\" for namespace \"" + aNamespace + "\"!", e);
        }
    }

    private AsymmetricAlgorithm getEncryptAlgorithm(String aMessage, String aSignature) throws CryptException {
        for (SignatureAlgorithm eSignatureAlgorithm : this._signatureAlgorithmToEncryptAlgorithms.keySet()) {
            if (!eSignatureAlgorithm.verify(aMessage.getBytes(), aSignature, (Converter)this._base64Converter)) continue;
            LOGGER.debug("Using public key \"" + this._signatureAlgorithmToPublicKeyPath.get(eSignatureAlgorithm) + "\" for encryption identifying a signature ...");
            return this._signatureAlgorithmToEncryptAlgorithms.get(eSignatureAlgorithm);
        }
        return null;
    }
}

