/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.asymmetric.AsymmetricAlgorithm;
import edu.vt.middleware.crypt.asymmetric.RSA;
import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.digest.SHA512;
import edu.vt.middleware.crypt.signature.RSASignature;
import edu.vt.middleware.crypt.signature.SignatureAlgorithm;
import edu.vt.middleware.crypt.util.Base64Converter;
import edu.vt.middleware.crypt.util.Converter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.forwardsecrecy.AbstractDecryptionService;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.CipherVersionFactory;
import org.refcodes.forwardsecrecy.CipherVersionFactoryImpl;
import org.refcodes.forwardsecrecy.DecryptionServer;
import org.refcodes.forwardsecrecy.ForwardSecrecyUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public class PublicKeyDecryptionService
extends AbstractDecryptionService {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private CipherVersionFactory<CipherVersion> _cipherVersionFactory;
    private AsymmetricAlgorithm _decryptAlgorithm = new RSA();
    private Base64Converter _base64Converter = new Base64Converter();
    private SignatureAlgorithm _signatureAlgorithm = new RSASignature((DigestAlgorithm)new SHA512());
    private String _privateKeyPath;

    public PublicKeyDecryptionService(String aNamespece, String aPrivateKeyPath, DecryptionServer aDecryptionServer, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws CryptException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        this(aNamespece, aPrivateKeyPath, null, aDecryptionServer, aCipherVersionFactory);
    }

    public PublicKeyDecryptionService(String aNamespece, String aPrivateKeyPath, DecryptionServer aDecryptionServer) throws CryptException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        this(aNamespece, aPrivateKeyPath, null, aDecryptionServer, new CipherVersionFactoryImpl());
    }

    public PublicKeyDecryptionService(String aNamespece, String aPrivateKeyPath, String aPrivateKeyPassPhrase, DecryptionServer aDecryptionServer) throws CryptException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        this(aNamespece, aPrivateKeyPath, aPrivateKeyPassPhrase, aDecryptionServer, new CipherVersionFactoryImpl());
    }

    public PublicKeyDecryptionService(String aNamespece, String aPrivateKeyPath, String aPrivateKeyPassPhrase, DecryptionServer aDecryptionServer, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws CryptException, IOException, InvalidKeySpecException, NoSuchAlgorithmException {
        super(aNamespece, aDecryptionServer);
        this._cipherVersionFactory = aCipherVersionFactory;
        this._privateKeyPath = aPrivateKeyPath;
        File thePrivateKeyFile = new File(aPrivateKeyPath);
        LOGGER.debug("Loading private key from file \"" + thePrivateKeyFile.getAbsolutePath() + "\"...");
        try {
            PrivateKey thePrivateKey = ForwardSecrecyUtility.readPrivateKey(thePrivateKeyFile, aPrivateKeyPassPhrase);
            this._decryptAlgorithm.setKey((Key)thePrivateKey);
            this._decryptAlgorithm.initDecrypt();
            this._signatureAlgorithm.setSignKey(thePrivateKey);
            this._signatureAlgorithm.initSign();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Unable to load private key from file \"" + thePrivateKeyFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e) + "\"");
            throw e;
        }
        catch (CryptException e) {
            LOGGER.error("Unable to instantiate private key from file   \"" + thePrivateKeyFile.getAbsolutePath() + " possibly due to a \"Java Cryptography Extension (JCE)\" with limited Strength (in that case please update to \"Java Cryptography Extension (JCE) Unlimited Strength\") \": " + ExceptionUtility.toMessage((Throwable)e) + "\"");
            throw e;
        }
    }

    @Override
    protected String toSignature(String aMessage) {
        LOGGER.debug("Using private key \"" + this._privateKeyPath + "\" for signing a message used to identify a public key ...");
        try {
            return this._signatureAlgorithm.sign(aMessage.getBytes(), (Converter)this._base64Converter);
        }
        catch (CryptException e) {
            throw new HiddenException((Throwable)e);
        }
    }

    @Override
    protected String createMessage() {
        return ForwardSecrecyUtility.createMessage();
    }

    @Override
    protected <CV extends CipherVersion> CV toDecryptedCipherVersion(CV aEncyrptedCipherVersion) {
        LOGGER.debug("Using private key \"" + this._privateKeyPath + "\" for decrypting a cipher ...");
        try {
            return (CV)this._cipherVersionFactory.createInstance(aEncyrptedCipherVersion.getUniversalId(), new String(this._decryptAlgorithm.decrypt(aEncyrptedCipherVersion.getCipher(), (Converter)this._base64Converter)));
        }
        catch (CryptException e) {
            throw new HiddenException((Throwable)e);
        }
    }
}

