/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.asymmetric.AsymmetricAlgorithm;
import edu.vt.middleware.crypt.asymmetric.RSA;
import edu.vt.middleware.crypt.util.Base64Converter;
import edu.vt.middleware.crypt.util.Converter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.exception.HiddenException;
import org.refcodes.forwardsecrecy.AbstractEncryptionService;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.CipherVersionFactory;
import org.refcodes.forwardsecrecy.CipherVersionFactoryImpl;
import org.refcodes.forwardsecrecy.CipherVersionGenerator;
import org.refcodes.forwardsecrecy.CipherVersionGeneratorImpl;
import org.refcodes.forwardsecrecy.EncryptionServer;
import org.refcodes.forwardsecrecy.ForwardSecrecyUtility;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.RuntimeLoggerFactorySingleton;

public class PublicKeyEncryptionService
extends AbstractEncryptionService {
    private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();
    private CipherVersionFactory<CipherVersion> _cipherVersionFactory;
    private AsymmetricAlgorithm _encryptAlgorithm = new RSA();
    private Base64Converter _base64Converter = new Base64Converter();
    private String _publicKeyPath;

    public PublicKeyEncryptionService(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer) throws CryptException, IOException, GeneralSecurityException {
        this(aNamespace, aPublicKeyPath, aEncryptionServer, new CipherVersionGeneratorImpl(), new CipherVersionFactoryImpl());
    }

    public PublicKeyEncryptionService(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer, CipherVersionGenerator<CipherVersion> aCipherVersionGenerator) throws CryptException, IOException, GeneralSecurityException {
        this(aNamespace, aPublicKeyPath, aEncryptionServer, aCipherVersionGenerator, new CipherVersionFactoryImpl());
    }

    public PublicKeyEncryptionService(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws CryptException, IOException, GeneralSecurityException {
        this(aNamespace, aPublicKeyPath, aEncryptionServer, new CipherVersionGeneratorImpl(), aCipherVersionFactory);
    }

    public PublicKeyEncryptionService(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer, CipherVersionGenerator<CipherVersion> aCipherVersionGenerator, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws GeneralSecurityException, CryptException, IOException {
        super(aNamespace, aEncryptionServer, aCipherVersionGenerator);
        this._cipherVersionFactory = aCipherVersionFactory;
        this._publicKeyPath = aPublicKeyPath;
        File thePublicKeyFile = new File(aPublicKeyPath);
        LOGGER.debug("Loading public key from file \"" + thePublicKeyFile.getAbsolutePath() + "\"...");
        try {
            PublicKey thePublicKey = ForwardSecrecyUtility.readPublicKey(thePublicKeyFile);
            this._encryptAlgorithm.setKey((Key)thePublicKey);
            this._encryptAlgorithm.initEncrypt();
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Public key file \"" + thePublicKeyFile.getAbsolutePath() + "\" not found: " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
        catch (IOException e) {
            LOGGER.warn("Unable to load public key from file \"" + thePublicKeyFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
        catch (GeneralSecurityException e) {
            LOGGER.warn("Encountered a security problem loading public key from file \"" + thePublicKeyFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
    }

    @Override
    protected <CV extends CipherVersion> CV toEncryptedCipherVersion(CV aDecryptedCipherVersion) {
        LOGGER.debug("Using public key \"" + this._publicKeyPath + "\" for encrypting ...");
        try {
            return (CV)this._cipherVersionFactory.createInstance(aDecryptedCipherVersion.getUniversalId(), this._encryptAlgorithm.encrypt(aDecryptedCipherVersion.getCipher().getBytes(), (Converter)this._base64Converter));
        }
        catch (CryptException e) {
            throw new HiddenException((Throwable)e);
        }
    }
}

