/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.refcodes.data.Encoding;
import org.refcodes.forwardsecrecy.DecryptionProviderImpl;
import org.refcodes.forwardsecrecy.DecryptionService;
import org.refcodes.forwardsecrecy.EncryptionProviderImpl;
import org.refcodes.forwardsecrecy.EncryptionServer;
import org.refcodes.forwardsecrecy.EncryptionService;
import org.refcodes.forwardsecrecy.InMemoryDecryptionServer;
import org.refcodes.forwardsecrecy.InMemoryEncryptionServer;
import org.refcodes.forwardsecrecy.LoopbackDecryptionService;
import org.refcodes.forwardsecrecy.LoopbackEncryptionService;

public class ForwardSecrecyTest {
    private static boolean IS_TEST_LOG_ENABLED = Boolean.getBoolean("test.log");
    private static final String NAMESPACE = "test";

    @Test
    public void testCryptographyInfrystructure() throws Exception {
        InMemoryDecryptionServer theDecryptionServer = new InMemoryDecryptionServer();
        LoopbackDecryptionService theDecryptionService = new LoopbackDecryptionService(NAMESPACE, theDecryptionServer);
        theDecryptionService.setCipherVersionsExpireTimeInMs(500L);
        DecryptionProviderImpl theDecryptionProvider = new DecryptionProviderImpl((DecryptionService)theDecryptionService);
        InMemoryEncryptionServer theEncryptionServer = new InMemoryEncryptionServer(theDecryptionServer);
        LoopbackEncryptionService theEncryptionService = new LoopbackEncryptionService(NAMESPACE, (EncryptionServer)theEncryptionServer);
        EncryptionProviderImpl theEncryptionProvider = new EncryptionProviderImpl((EncryptionService)theEncryptionService);
        String theText = "Hallo Welt!";
        String theEncryptedText = theEncryptionProvider.toEncrypted(theText);
        String theDecryptedText = theDecryptionProvider.toDecrypted(theEncryptedText);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theEncryptedText + " -> " + theDecryptedText);
        }
        Assertions.assertEquals((Object)theText, (Object)theDecryptedText);
        theEncryptionProvider.nextCipherVersion();
        String theEncryptedText2 = theEncryptionProvider.toEncrypted(theText);
        String theDecryptedText2 = theDecryptionProvider.toDecrypted(theEncryptedText);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theEncryptedText2 + " -> " + theDecryptedText2);
        }
        Assertions.assertEquals((Object)theText, (Object)theDecryptedText2);
        theDecryptedText = theDecryptionProvider.toDecrypted(theEncryptedText);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theEncryptedText + " -> " + theDecryptedText);
        }
        Assertions.assertEquals((Object)theText, (Object)theDecryptedText);
        for (int i = 0; i < 50; ++i) {
            theEncryptionProvider.nextCipherVersion();
            String eEncryptedText = theEncryptionProvider.toEncrypted(theText);
            String eDecryptedText = theDecryptionProvider.toDecrypted(theEncryptedText);
            if (IS_TEST_LOG_ENABLED) {
                System.out.println(eEncryptedText + " -> " + eDecryptedText);
            }
            Assertions.assertEquals((Object)theText, (Object)eDecryptedText);
        }
    }

    @Test
    public void testCryptographyProvider() throws Exception {
        InMemoryDecryptionServer theDecryptionServer = new InMemoryDecryptionServer();
        LoopbackDecryptionService theDecryptionService = new LoopbackDecryptionService(NAMESPACE, theDecryptionServer);
        theDecryptionService.setCipherVersionsExpireTimeInMs(500L);
        DecryptionProviderImpl theDecryptionProvider = new DecryptionProviderImpl((DecryptionService)theDecryptionService);
        InMemoryEncryptionServer theEncryptionServer = new InMemoryEncryptionServer(theDecryptionServer);
        LoopbackEncryptionService theEncryptionService = new LoopbackEncryptionService(NAMESPACE, (EncryptionServer)theEncryptionServer);
        EncryptionProviderImpl theEncryptionProvider = new EncryptionProviderImpl((EncryptionService)theEncryptionService);
        String theInput = "Hallo Welt!";
        String theEncryptedText1 = theEncryptionProvider.toEncrypted(theInput);
        String theOutputText1 = theDecryptionProvider.toDecrypted(theEncryptedText1);
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theEncryptedText1 + " -> " + theOutputText1);
        }
        Assertions.assertEquals((Object)theInput, (Object)theOutputText1);
        byte[] theInputHex2 = theInput.getBytes(Encoding.UTF_8.getCode());
        byte[] theEncryptedHex2 = new byte[theEncryptedText1.getBytes(Encoding.UTF_8.getCode()).length];
        theEncryptionProvider.toEncrypted(theInputHex2, 0, theInputHex2.length, theEncryptedHex2, 0);
        String theEncryptedText2 = new String(theEncryptedHex2, Encoding.UTF_8.getCode());
        byte[] theDecryptedHex2 = new byte[theInputHex2.length];
        theDecryptionProvider.toDecrypted(theEncryptedHex2, 0, theEncryptedHex2.length, theDecryptedHex2, 0);
        String theOutputText2 = new String(theDecryptedHex2, Encoding.UTF_8.getCode());
        if (IS_TEST_LOG_ENABLED) {
            System.out.println(theEncryptedText2 + " -> " + theOutputText2);
        }
        Assertions.assertEquals((Object)theInput, (Object)theOutputText2);
    }
}

