/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt;

import edu.vt.middleware.crypt.Algorithm;
import java.security.SecureRandom;

public abstract class AbstractAlgorithm
implements Algorithm {
    private static final int DEFAULT_RANDOM_BYTE_SIZE = 256;
    protected String algorithm;
    protected SecureRandom randomProvider;
    protected int randomByteSize = 256;

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setRandomProvider(SecureRandom random) {
        this.randomProvider = random;
    }

    public String toString() {
        return this.algorithm;
    }

    @Override
    public byte[] getRandomData(int nBytes) {
        if (this.randomProvider == null) {
            throw new IllegalStateException("No random provider available.");
        }
        byte[] data = new byte[nBytes];
        this.randomProvider.nextBytes(data);
        return data;
    }
}

