/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt;

import edu.vt.middleware.crypt.AbstractAlgorithm;
import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.CryptProvider;
import edu.vt.middleware.crypt.EncryptionAlgorithm;
import edu.vt.middleware.crypt.util.Converter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;

public abstract class AbstractEncryptionAlgorithm
extends AbstractAlgorithm
implements EncryptionAlgorithm {
    protected Cipher cipher;
    protected String mode;
    protected String padding;
    protected int cipherMode;
    protected Key key;

    protected AbstractEncryptionAlgorithm(String cipherAlgorithm, String cipherModeName, String cipherPadding) {
        this.algorithm = cipherAlgorithm;
        this.mode = cipherModeName;
        this.padding = cipherPadding;
        try {
            this.initCipher();
        }
        catch (CryptException e) {
            throw new RuntimeException("Error initializing cipher with name " + this.algorithm, e);
        }
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public String getPadding() {
        return this.padding;
    }

    @Override
    public void setKey(Key k) {
        this.key = k;
    }

    @Override
    public int getCipherMode() {
        return this.cipherMode;
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }

    @Override
    public void initEncrypt() throws CryptException {
        this.init(1);
    }

    @Override
    public void initDecrypt() throws CryptException {
        this.init(2);
    }

    @Override
    public byte[] encrypt(byte[] plaintext) throws CryptException {
        if (this.cipherMode != 1) {
            throw new CryptException("Cipher is not in encryption mode.");
        }
        return this.crypt(plaintext);
    }

    @Override
    public String encrypt(byte[] plaintext, Converter converter) throws CryptException {
        return converter.fromBytes(this.encrypt(plaintext));
    }

    @Override
    public void encrypt(InputStream in, OutputStream out) throws CryptException, IOException {
        if (this.cipherMode != 1) {
            throw new CryptException("Cipher is not in encryption mode.");
        }
        this.crypt(in, out);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) throws CryptException {
        if (this.cipherMode != 2) {
            throw new CryptException("Cipher is not in decryption mode.");
        }
        return this.crypt(ciphertext);
    }

    @Override
    public byte[] decrypt(String ciphertext, Converter converter) throws CryptException {
        return this.decrypt(converter.toBytes(ciphertext));
    }

    @Override
    public void decrypt(InputStream in, OutputStream out) throws CryptException, IOException {
        if (this.cipherMode != 2) {
            throw new CryptException("Cipher is not in decryption mode.");
        }
        this.crypt(in, out);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.algorithm);
        sb.append('/');
        sb.append(this.mode);
        sb.append('/');
        sb.append(this.padding);
        return sb.toString();
    }

    protected void initCipher() throws CryptException {
        this.cipher = CryptProvider.getCipher(this.algorithm, this.mode, this.padding);
        if (this.randomProvider == null) {
            this.randomProvider = new SecureRandom();
        }
    }

    protected void init(int encryptOrDecrypt) throws CryptException {
        if (this.cipher == null) {
            throw new CryptException("Cipher not initialized.");
        }
        this.cipherMode = encryptOrDecrypt;
        try {
            AlgorithmParameterSpec algSpec = this.getAlgorithmParameterSpec();
            if (algSpec != null) {
                this.cipher.init(encryptOrDecrypt, this.key, algSpec, this.randomProvider);
            } else {
                this.cipher.init(encryptOrDecrypt, this.key, this.randomProvider);
            }
        }
        catch (InvalidKeyException e) {
            throw new CryptException("Invalid key for " + this, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new CryptException("Invalid cipher parameters.", e);
        }
    }

    protected byte[] crypt(byte[] in) throws CryptException {
        try {
            return this.cipher.doFinal(in);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptException("Bad block size.", e);
        }
        catch (BadPaddingException e) {
            throw new CryptException("Bad padding.", e);
        }
    }

    protected void crypt(InputStream in, OutputStream out) throws CryptException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream cannot be null.");
        }
        if (out == null) {
            throw new IllegalArgumentException("Output stream cannot be null.");
        }
        byte[] inBuffer = new byte[this.getChunkSize()];
        byte[] outBuffer = new byte[this.getChunkSize() * 2];
        try {
            int inCount;
            while ((inCount = in.read(inBuffer)) > 0) {
                int outCount = this.cipher.update(inBuffer, 0, inCount, outBuffer);
                out.write(outBuffer, 0, outCount);
            }
            byte[] end = this.cipher.doFinal();
            out.write(end);
        }
        catch (BadPaddingException e) {
            throw new CryptException("Bad padding.", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CryptException("Bad block size.", e);
        }
        catch (ShortBufferException e) {
            throw new CryptException("Output buffer is too small.", e);
        }
    }

    protected abstract AlgorithmParameterSpec getAlgorithmParameterSpec();

    protected abstract int getChunkSize();
}

