/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt;

import edu.vt.middleware.crypt.CryptException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class CryptProvider {
    public static final int RANDOM_BYTE_ARRAY_SIZE = 256;
    private static String[] providers = new String[0];

    static {
        CryptProvider.addProvider((Provider)new BouncyCastleProvider(), "BC");
    }

    private CryptProvider() {
    }

    public static void addProvider(Provider provider, String name) {
        Security.addProvider(provider);
        String[] tmp = new String[providers.length + 1];
        System.arraycopy(providers, 0, tmp, 0, providers.length);
        tmp[CryptProvider.providers.length] = name;
        providers = tmp;
    }

    public static Cipher getCipher(String algorithm, String mode, String padding) throws CryptException {
        Cipher cipher = null;
        String transformation = mode != null && padding != null ? String.valueOf(algorithm) + "/" + mode + "/" + padding : (mode != null ? String.valueOf(algorithm) + "/" + mode : algorithm);
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            try {
                cipher = Cipher.getInstance(transformation, provider);
                break;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(provider, algorithm, e);
            }
            ++n2;
        }
        if (cipher == null) {
            try {
                cipher = Cipher.getInstance(transformation);
            }
            catch (NoSuchPaddingException e) {
                throw new CryptException(e.getMessage());
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(null, algorithm, e);
                throw new CryptException(e.getMessage());
            }
        }
        return cipher;
    }

    public static SecretKeyFactory getSecretKeyFactory(String algorithm) throws CryptException {
        SecretKeyFactory kf = null;
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            try {
                kf = SecretKeyFactory.getInstance(algorithm, provider);
                break;
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(provider, algorithm, e);
                ++n2;
            }
        }
        if (kf == null) {
            try {
                kf = SecretKeyFactory.getInstance(algorithm);
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(null, algorithm, e);
                throw new CryptException(e.getMessage());
            }
        }
        return kf;
    }

    public static KeyFactory getKeyFactory(String algorithm) throws CryptException {
        KeyFactory kf = null;
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            try {
                kf = KeyFactory.getInstance(algorithm, provider);
                break;
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(provider, algorithm, e);
                ++n2;
            }
        }
        if (kf == null) {
            try {
                kf = KeyFactory.getInstance(algorithm);
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(null, algorithm, e);
                throw new CryptException(e.getMessage());
            }
        }
        return kf;
    }

    public static KeyGenerator getKeyGenerator(String algorithm) throws CryptException {
        KeyGenerator generator = null;
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            try {
                generator = KeyGenerator.getInstance(algorithm, provider);
                break;
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(provider, algorithm, e);
                ++n2;
            }
        }
        if (generator == null) {
            try {
                generator = KeyGenerator.getInstance(algorithm);
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(null, algorithm, e);
                throw new CryptException(e.getMessage());
            }
        }
        return generator;
    }

    public static KeyPairGenerator getKeyPairGenerator(String algorithm) throws CryptException {
        KeyPairGenerator generator = null;
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            try {
                generator = KeyPairGenerator.getInstance(algorithm, provider);
                break;
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(provider, algorithm, e);
                ++n2;
            }
        }
        if (generator == null) {
            try {
                generator = KeyPairGenerator.getInstance(algorithm);
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(null, algorithm, e);
                throw new CryptException(e.getMessage());
            }
        }
        return generator;
    }

    public static Signature getSignature(String digestAlgorithm, String algorithm, String padding) throws CryptException {
        Signature sig = null;
        String transformation = digestAlgorithm != null && padding != null ? String.valueOf(digestAlgorithm) + "/" + algorithm + "/" + padding : (digestAlgorithm != null ? String.valueOf(digestAlgorithm) + "/" + algorithm : algorithm);
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            try {
                sig = Signature.getInstance(transformation, provider);
                break;
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(provider, algorithm, e);
                ++n2;
            }
        }
        if (sig == null) {
            try {
                sig = Signature.getInstance(transformation);
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(null, algorithm, e);
                throw new CryptException(e.getMessage());
            }
        }
        return sig;
    }

    public static MessageDigest getMessageDigest(String algorithm) throws CryptException {
        MessageDigest digest = null;
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            try {
                digest = MessageDigest.getInstance(algorithm, provider);
                break;
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(provider, algorithm, e);
                ++n2;
            }
        }
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance(algorithm);
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(null, algorithm, e);
                throw new CryptException(e.getMessage());
            }
        }
        return digest;
    }

    public static KeyStore getKeyStore(String type) throws CryptException {
        KeyStore store = null;
        String keyStoreType = type;
        if (keyStoreType == null) {
            keyStoreType = KeyStore.getDefaultType();
        }
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            try {
                store = KeyStore.getInstance(keyStoreType, provider);
                break;
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(provider, type, e);
                ++n2;
            }
        }
        if (store == null) {
            try {
                store = KeyStore.getInstance(keyStoreType);
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(null, type, e);
                throw new CryptException(e.getMessage());
            }
        }
        return store;
    }

    public static KeyStore getKeyStore() throws CryptException {
        return CryptProvider.getKeyStore(null);
    }

    public static CertificateFactory getCertificateFactory(String type) throws CryptException {
        CertificateFactory cf = null;
        String[] stringArray = providers;
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            String provider = stringArray[n2];
            try {
                cf = CertificateFactory.getInstance(type, provider);
                break;
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(provider, type, e);
                ++n2;
            }
        }
        if (cf == null) {
            try {
                cf = CertificateFactory.getInstance(type);
            }
            catch (GeneralSecurityException e) {
                CryptProvider.handleProviderError(null, type, e);
                throw new CryptException(e.getMessage());
            }
        }
        return cf;
    }

    private static void handleProviderError(String provider, String algorithm, GeneralSecurityException error) {
        if (error instanceof NoSuchProviderException || error instanceof NoSuchAlgorithmException) {
            // empty if block
        }
    }
}

