/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.asymmetric;

import edu.vt.middleware.crypt.AbstractEncryptionAlgorithm;
import edu.vt.middleware.crypt.asymmetric.RSA;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;

public class AsymmetricAlgorithm
extends AbstractEncryptionAlgorithm {
    public static final String MODE = "NONE";
    public static final String PADDING = "OAEPPadding";
    private static final int CHUNK_SIZE = 2048;
    private static final Map<String, Class<? extends AsymmetricAlgorithm>> NAME_CLASS_MAP = new HashMap<String, Class<? extends AsymmetricAlgorithm>>();

    static {
        NAME_CLASS_MAP.put("RSA", RSA.class);
    }

    protected AsymmetricAlgorithm(String cipherAlgorithm) {
        super(cipherAlgorithm, MODE, PADDING);
    }

    public static AsymmetricAlgorithm newInstance(String algorithm) {
        Class<? extends AsymmetricAlgorithm> clazz = NAME_CLASS_MAP.get(algorithm.toUpperCase());
        if (clazz != null) {
            try {
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        return new AsymmetricAlgorithm(algorithm);
    }

    public Object clone() throws CloneNotSupportedException {
        AsymmetricAlgorithm clone = AsymmetricAlgorithm.newInstance(this.getAlgorithm());
        clone.setRandomProvider(this.randomProvider);
        clone.setKey(this.key);
        return clone;
    }

    @Override
    protected AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return null;
    }

    @Override
    protected int getChunkSize() {
        return 2048;
    }
}

