/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.io;

import edu.vt.middleware.crypt.io.DirectByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractEncodingFilterInputStream
extends FilterInputStream {
    protected static final int CHUNK_SIZE = 2048;
    protected final DirectByteArrayOutputStream decodeBuffer;
    protected final byte[] byteBuffer = new byte[2048];
    protected int position;

    protected AbstractEncodingFilterInputStream(InputStream in) {
        super(in);
        this.decodeBuffer = new DirectByteArrayOutputStream(this.getDecodeBufferCapacity());
    }

    @Override
    public int read() throws IOException {
        if (this.position == this.decodeBuffer.size() || this.decodeBuffer.size() == 0) {
            this.fillBuffer();
        }
        if (this.decodeBuffer.size() > 0) {
            return this.decodeBuffer.getBuffer()[this.position++];
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = 0;
        while (count < len) {
            if (this.position == this.decodeBuffer.size() || this.decodeBuffer.size() == 0) {
                this.fillBuffer();
            }
            if (this.decodeBuffer.size() == 0) break;
            b[off + count++] = this.decodeBuffer.getBuffer()[this.position++];
        }
        return count;
    }

    protected abstract int getDecodeBufferCapacity();

    protected abstract void fillBuffer() throws IOException;
}

