/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.io;

import edu.vt.middleware.crypt.io.AbstractEncodingFilterOutputStream;
import edu.vt.middleware.crypt.io.DirectByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Base64Encoder;

public class Base64FilterOutputStream
extends AbstractEncodingFilterOutputStream {
    public static final int LINE_LENGTH_64 = 64;
    public static final int LINE_LENGTH_76 = 76;
    public static final char LINE_TERMINATOR = '\n';
    private static final int BYTES_PER_GROUP = 3;
    private static final int CHARS_PER_GROUP = 4;
    private static final int BUFFER_SIZE = 1536;
    private final DirectByteArrayOutputStream writeBuffer = new DirectByteArrayOutputStream(1536);
    private final Base64Encoder encoder = new Base64Encoder();
    private final DirectByteArrayOutputStream lineBuffer;
    private int lineLength;
    private int position;

    public Base64FilterOutputStream(OutputStream out) {
        this(out, 0);
    }

    public Base64FilterOutputStream(OutputStream out, int charsPerLine) {
        super(out);
        if (charsPerLine == 0) {
            this.lineBuffer = null;
        } else if (charsPerLine == 64 || charsPerLine == 76) {
            this.lineBuffer = new DirectByteArrayOutputStream(2048);
        } else {
            throw new IllegalArgumentException("Invalid characters per line.");
        }
        this.lineLength = charsPerLine;
    }

    @Override
    public void close() throws IOException {
        this.flushToStream();
        if (this.lineLength > 0) {
            this.out.write(10);
        }
        super.close();
    }

    @Override
    protected void writeEncoded(byte[] data, int offset, int length) throws IOException {
        int remaining = 1536 - this.writeBuffer.size();
        if (length >= remaining) {
            int count = 0;
            do {
                this.writeBuffer.write(data, offset + count, remaining);
                this.flushToStream();
            } while ((count += remaining) + (remaining = 1536 - this.writeBuffer.size()) < length);
            this.writeBuffer.write(data, offset + count, length - count);
        } else {
            this.writeBuffer.write(data, offset, length);
        }
    }

    protected void flushToStream() throws IOException {
        if (this.lineLength == 0) {
            this.encoder.encode(this.writeBuffer.getBuffer(), 0, this.writeBuffer.size(), this.out);
        } else {
            this.lineBuffer.reset();
            this.encoder.encode(this.writeBuffer.getBuffer(), 0, this.writeBuffer.size(), (OutputStream)this.lineBuffer);
            int count = 0;
            if (this.position > 0) {
                count = this.lineLength - this.position;
                this.out.write(this.lineBuffer.getBuffer(), 0, count);
                this.out.write(10);
            }
            while (count + this.lineLength < this.lineBuffer.size()) {
                this.out.write(this.lineBuffer.getBuffer(), count, this.lineLength);
                this.out.write(10);
                count += this.lineLength;
            }
            this.position = this.lineBuffer.size() - count;
            if (this.position > 0) {
                this.out.write(this.lineBuffer.getBuffer(), count, this.position);
            }
        }
        this.writeBuffer.reset();
    }
}

