/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.signature;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.signature.SignatureAlgorithm;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public abstract class AbstractDSASignature
extends SignatureAlgorithm {
    protected DSA signer;

    protected AbstractDSASignature(String alg) {
        super(alg);
    }

    @Override
    public byte[] sign(byte[] data) throws CryptException {
        BigInteger[] out = this.signer.generateSignature(this.digest.digest(data));
        return this.encode(out[0], out[1]);
    }

    @Override
    public byte[] sign(InputStream in) throws CryptException, IOException {
        BigInteger[] out = this.signer.generateSignature(this.digest.digest(in));
        return this.encode(out[0], out[1]);
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws CryptException {
        BigInteger[] sig = this.decode(signature);
        return this.signer.verifySignature(this.digest.digest(data), sig[0], sig[1]);
    }

    @Override
    public boolean verify(InputStream in, byte[] signature) throws CryptException, IOException {
        BigInteger[] sig = this.decode(signature);
        return this.signer.verifySignature(this.digest.digest(in), sig[0], sig[1]);
    }

    protected void init(boolean forSigning, CipherParameters params) {
        if (forSigning && this.randomProvider != null) {
            this.signer.init(forSigning, (CipherParameters)new ParametersWithRandom(params, this.randomProvider));
        } else {
            this.signer.init(forSigning, params);
        }
    }

    private byte[] encode(BigInteger r, BigInteger s) throws CryptException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        try {
            ASN1OutputStream.create((OutputStream)out).writeObject((ASN1Primitive)new DERSequence(v));
        }
        catch (IOException e) {
            throw new CryptException("Error encoding DSA signature.", e);
        }
        return out.toByteArray();
    }

    private BigInteger[] decode(byte[] in) throws CryptException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (ASN1InputStream theAsn1InputStream = new ASN1InputStream(in);){
                ASN1Sequence s = (ASN1Sequence)theAsn1InputStream.readObject();
                return new BigInteger[]{((ASN1Integer)s.getObjectAt(0)).getValue(), ((ASN1Integer)s.getObjectAt(1)).getValue()};
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CryptException("Error decoding DSA signature.", e);
        }
    }
}

