/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.signature;

import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.digest.SHA1;
import edu.vt.middleware.crypt.signature.AbstractDSASignature;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSASigner;

public class DSASignature
extends AbstractDSASignature {
    private static final String ALGORITHM = "DSA";

    public DSASignature() {
        this(new SHA1());
    }

    public DSASignature(DigestAlgorithm d) {
        super(ALGORITHM);
        this.digest = d;
        this.signer = new DSASigner();
    }

    @Override
    public void setSignKey(PrivateKey key) {
        if (!DSAPrivateKey.class.isInstance(key)) {
            throw new IllegalArgumentException("DSA private key required.");
        }
        super.setSignKey(key);
    }

    @Override
    public void setVerifyKey(PublicKey key) {
        if (!DSAPublicKey.class.isInstance(key)) {
            throw new IllegalArgumentException("DSA public key required.");
        }
        super.setVerifyKey(key);
    }

    @Override
    public void initSign() {
        if (this.signKey == null) {
            throw new IllegalStateException("Sign key must be set prior to initialization.");
        }
        DSAPrivateKey privKey = (DSAPrivateKey)this.signKey;
        DSAParams params = privKey.getParams();
        DSAPrivateKeyParameters bcParams = new DSAPrivateKeyParameters(privKey.getX(), new DSAParameters(params.getP(), params.getQ(), params.getG()));
        this.init(true, (CipherParameters)bcParams);
    }

    @Override
    public void initVerify() {
        if (this.verifyKey == null) {
            throw new IllegalStateException("Verify key must be set prior to initialization.");
        }
        DSAPublicKey pubKey = (DSAPublicKey)this.verifyKey;
        DSAParams params = pubKey.getParams();
        DSAPublicKeyParameters bcParams = new DSAPublicKeyParameters(pubKey.getY(), new DSAParameters(params.getP(), params.getQ(), params.getG()));
        this.init(false, (CipherParameters)bcParams);
    }
}

