/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.signature;

import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.digest.SHA1;
import edu.vt.middleware.crypt.signature.AbstractDSASignature;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;

public class ECDSASignature
extends AbstractDSASignature {
    private static final String ALGORITHM = "ECDSA";

    public ECDSASignature() {
        this(new SHA1());
    }

    public ECDSASignature(DigestAlgorithm d) {
        super(ALGORITHM);
        this.digest = d;
        this.signer = new ECDSASigner();
    }

    @Override
    public void setSignKey(PrivateKey key) {
        if (!ECPrivateKey.class.isInstance(key)) {
            throw new IllegalArgumentException("EC private key required.");
        }
        super.setSignKey(key);
    }

    @Override
    public void setVerifyKey(PublicKey key) {
        if (!ECPublicKey.class.isInstance(key)) {
            throw new IllegalArgumentException("EC public key required.");
        }
        super.setVerifyKey(key);
    }

    @Override
    public void initSign() {
        if (this.signKey == null) {
            throw new IllegalStateException("Sign key must be set prior to initialization.");
        }
        try {
            this.init(true, (CipherParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)this.signKey));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Cannot convert private key to BC format", e);
        }
    }

    @Override
    public void initVerify() {
        if (this.verifyKey == null) {
            throw new IllegalStateException("Verify key must be set prior to initialization.");
        }
        try {
            this.init(false, (CipherParameters)ECUtil.generatePublicKeyParameter((PublicKey)this.verifyKey));
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException("Cannot convert public key to BC format", e);
        }
    }

    @Override
    protected void init(boolean forSigning, CipherParameters params) {
        if (forSigning && this.randomProvider != null) {
            this.signer.init(forSigning, (CipherParameters)new ParametersWithRandom(params, this.randomProvider));
        } else {
            this.signer.init(forSigning, params);
        }
    }
}

