/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.signature;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.digest.DigestAlgorithm;
import edu.vt.middleware.crypt.digest.SHA1;
import edu.vt.middleware.crypt.signature.SignatureAlgorithm;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.signers.RSADigestSigner;

public class RSASignature
extends SignatureAlgorithm {
    private static final String ALGORITHM = "RSA";
    private final RSADigestSigner signer;

    public RSASignature() {
        this(new SHA1());
    }

    public RSASignature(DigestAlgorithm d) {
        super(ALGORITHM);
        this.digest = d;
        this.signer = new RSADigestSigner(d.getDigest());
    }

    @Override
    public void setSignKey(PrivateKey key) {
        if (!RSAPrivateKey.class.isInstance(key)) {
            throw new IllegalArgumentException("RSA private key required.");
        }
        super.setSignKey(key);
    }

    @Override
    public void setVerifyKey(PublicKey key) {
        if (!RSAPublicKey.class.isInstance(key)) {
            throw new IllegalArgumentException("RSA public key required.");
        }
        super.setVerifyKey(key);
    }

    @Override
    public void initSign() {
        if (this.signKey == null) {
            throw new IllegalStateException("Sign key must be set prior to initialization.");
        }
        RSAPrivateKey privKey = (RSAPrivateKey)this.signKey;
        this.init(true, (CipherParameters)new RSAKeyParameters(true, privKey.getModulus(), privKey.getPrivateExponent()));
    }

    @Override
    public void initVerify() {
        if (this.verifyKey == null) {
            throw new IllegalStateException("Verify key must be set prior to initialization.");
        }
        RSAPublicKey pubKey = (RSAPublicKey)this.verifyKey;
        this.init(false, (CipherParameters)new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent()));
    }

    @Override
    public byte[] sign(byte[] data) throws CryptException {
        this.signer.update(data, 0, data.length);
        try {
            return this.signer.generateSignature();
        }
        catch (DataLengthException e) {
            throw new CryptException("Data is too long for message digest.", e);
        }
        catch (CryptoException e) {
            throw new CryptException("Cryptographic error.", e);
        }
    }

    @Override
    public byte[] sign(InputStream in) throws CryptException, IOException {
        this.chunkUpdate(in);
        try {
            return this.signer.generateSignature();
        }
        catch (DataLengthException e) {
            throw new CryptException("Data is too long for message digest.", e);
        }
        catch (CryptoException e) {
            throw new CryptException("Cryptographic error.", e);
        }
    }

    @Override
    public boolean verify(byte[] data, byte[] signature) throws CryptException {
        this.signer.update(data, 0, data.length);
        return this.signer.verifySignature(signature);
    }

    @Override
    public boolean verify(InputStream in, byte[] signature) throws CryptException, IOException {
        this.chunkUpdate(in);
        return this.signer.verifySignature(signature);
    }

    protected void init(boolean forSigning, CipherParameters params) {
        if (this.randomProvider != null) {
            this.signer.init(forSigning, (CipherParameters)new ParametersWithRandom(params, this.randomProvider));
        } else {
            this.signer.init(forSigning, params);
        }
    }

    protected void chunkUpdate(InputStream in) throws IOException {
        int count;
        byte[] buffer = new byte[4096];
        while ((count = in.read(buffer, 0, 4096)) > 0) {
            this.signer.update(buffer, 0, count);
        }
    }
}

