/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.util;

import edu.vt.middleware.crypt.util.Convert;
import edu.vt.middleware.crypt.util.Converter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.bouncycastle.util.encoders.Encoder;

public abstract class AbstractEncodingConverter
implements Converter {
    @Override
    public String fromBytes(byte[] input) {
        return this.fromBytes(input, 0, input.length);
    }

    @Override
    public String fromBytes(byte[] input, int offset, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.getEncoder().encode(input, offset, length, (OutputStream)out);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        try {
            return out.toString(Convert.ASCII_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("ASCII character set not available.");
        }
    }

    @Override
    public byte[] toBytes(String input) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.getEncoder().decode(input, (OutputStream)out);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return out.toByteArray();
    }

    protected abstract Encoder getEncoder();
}

