/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.util;

import edu.vt.middleware.crypt.util.Base64Converter;
import edu.vt.middleware.crypt.util.HexConverter;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public final class Convert {
    public static final String CHARSET_PROPERTY = "edu.vt.middleware.crypt.charset";
    public static final Charset ASCII_CHARSET = Charset.forName("ASCII");
    public static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static final HexConverter HEX_CONVERTER = new HexConverter();
    private static final Base64Converter B64_CONVERTER = new Base64Converter();

    private Convert() {
    }

    public static Charset getDefaultCharset() {
        String charSetName = System.getProperty(CHARSET_PROPERTY);
        if (charSetName != null) {
            return Charset.forName(System.getProperty(charSetName));
        }
        return DEFAULT_CHARSET;
    }

    public static byte[] toBytes(String[] input) {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] stringArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            try {
                data.write(s.getBytes(Convert.getDefaultCharset().name()));
            }
            catch (Exception e) {
                throw new IllegalStateException("Error decoding " + s);
            }
            ++n2;
        }
        return data.toByteArray();
    }

    public static byte[] toBytes(String input) {
        try {
            return input.getBytes(Convert.getDefaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Error decoding " + input);
        }
    }

    public static byte[] toBytes(char[] input) {
        try {
            return new String(input).getBytes(Convert.getDefaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Error decoding input characters.");
        }
    }

    public static byte[] toAsciiBytes(String input) {
        try {
            return input.getBytes(ASCII_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Error decoding " + input);
        }
    }

    public static String toString(byte[] input) {
        try {
            return new String(input, Convert.getDefaultCharset().name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Error decoding input bytes.");
        }
    }

    public static byte[] fromHex(String hex) {
        return HEX_CONVERTER.toBytes(hex);
    }

    public static String toHex(byte[] input) {
        return HEX_CONVERTER.fromBytes(input);
    }

    public static byte[] fromBase64(String base64) {
        return B64_CONVERTER.toBytes(base64);
    }

    public static String toBase64(byte[] input) {
        return B64_CONVERTER.fromBytes(input);
    }
}

