/*
 * Decompiled with CFR 0.152.
 */
package edu.vt.middleware.crypt.util;

import edu.vt.middleware.crypt.util.AbstractEncodingConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.Encoder;
import org.bouncycastle.util.encoders.HexEncoder;

public class HexConverter
extends AbstractEncodingConverter {
    public static final String DEFAULT_BYTE_DELIMITER = ":";
    private final HexEncoder encoder = new HexEncoder();
    private boolean delimitBytesFlag;
    private String byteDelimiter;
    private Pattern splitPattern;

    public HexConverter() {
        this(false);
    }

    public HexConverter(boolean delimitBytes) {
        this.delimitBytesFlag = delimitBytes;
        this.setByteDelimiter(DEFAULT_BYTE_DELIMITER);
    }

    public String getByteDelimiter() {
        return this.byteDelimiter;
    }

    public void setByteDelimiter(String delim) {
        this.byteDelimiter = delim;
        if (this.delimitBytesFlag) {
            this.splitPattern = Pattern.compile(this.byteDelimiter);
        }
    }

    @Override
    public String fromBytes(byte[] input, int offset, int length) {
        if (this.delimitBytesFlag) {
            byte[] delimBytes = this.byteDelimiter.getBytes();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int i = offset;
            while (i < length) {
                try {
                    if (i > offset) {
                        out.write(delimBytes);
                    }
                    this.encoder.encode(input, offset + i, 1, (OutputStream)out);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                ++i;
            }
            return out.toString().toUpperCase();
        }
        return super.fromBytes(input, offset, length);
    }

    @Override
    public byte[] toBytes(String input) {
        if (this.delimitBytesFlag) {
            String[] hexBytes;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String[] stringArray = hexBytes = this.splitPattern.split(input);
            int n = hexBytes.length;
            int n2 = 0;
            while (n2 < n) {
                String hexByte = stringArray[n2];
                try {
                    this.encoder.decode(hexByte, (OutputStream)out);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e.getMessage());
                }
                ++n2;
            }
            return out.toByteArray();
        }
        return super.toBytes(input);
    }

    @Override
    protected Encoder getEncoder() {
        return this.encoder;
    }
}

