/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import org.refcodes.data.Text;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.CipherVersionFactory;
import org.refcodes.forwardsecrecy.CipherVersionGenerator;
import org.refcodes.forwardsecrecy.ForwardSecrecyUtility;

public abstract class AbstractCipherVersionGenerator<CV extends CipherVersion>
implements CipherVersionGenerator<CV> {
    private CipherVersionFactory<CV> _cipherVersionFactory;

    public AbstractCipherVersionGenerator(CipherVersionFactory<CV> aCipherVersionFactory) {
        this._cipherVersionFactory = aCipherVersionFactory;
    }

    public boolean hasNext() {
        return true;
    }

    public void remove() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    @Override
    public CV next() {
        return this._cipherVersionFactory.createInstance(this.createCipherUid(), this.createCipher());
    }

    protected String createCipherUid() {
        return ForwardSecrecyUtility.createCipherUid();
    }

    protected String createCipher() {
        return ForwardSecrecyUtility.createCipher();
    }
}

