/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import java.util.ArrayList;
import java.util.List;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.DecryptionServer;
import org.refcodes.forwardsecrecy.DecryptionService;
import org.refcodes.forwardsecrecy.SignatureVerificationException;

public abstract class AbstractDecryptionService
implements DecryptionService {
    protected static long EXPIRE_TIME_NEVER = -1L;
    protected static long EXPIRE_TIME_IMMEDIATELY = 0L;
    private DecryptionServer _decryptionServer;
    private String _namespace;
    private long _cipherVersionsExpireTimeMillis;
    private long _cipherVersionsLastLoadedTime = EXPIRE_TIME_IMMEDIATELY;
    private List<CipherVersion> _cipherVersions;

    public AbstractDecryptionService(String aNamespace, DecryptionServer aDecryptionServer, long aCipherVersionsExpireTimeMillis) {
        this._namespace = aNamespace;
        this._decryptionServer = aDecryptionServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CipherVersion> getCipherVersions() {
        if (this._cipherVersionsExpireTimeMillis == EXPIRE_TIME_NEVER && this._cipherVersions != null) {
            return this._cipherVersions;
        }
        long theCurrentTimeMs = System.currentTimeMillis();
        if (this.isLoadEncryptedCipherVersions(theCurrentTimeMs)) {
            AbstractDecryptionService abstractDecryptionService = this;
            synchronized (abstractDecryptionService) {
                if (this.isLoadEncryptedCipherVersions(theCurrentTimeMs)) {
                    List<CipherVersion> theEncryptedCipherVersions;
                    try {
                        String theMessage = this.createMessage();
                        String theSignature = this.toSignature(theMessage);
                        theEncryptedCipherVersions = this._decryptionServer.getCipherVersions(this._namespace, theMessage, theSignature);
                    }
                    catch (SignatureVerificationException e) {
                        throw new SignatureVerificationException.SignatureVerificationRuntimeException("Unexpected <" + SignatureVerificationException.class.getName() + ">: " + e.getMessage(), (Throwable)((Object)e));
                    }
                    ArrayList<CipherVersion> theCipherVersions = new ArrayList<CipherVersion>();
                    for (CipherVersion eCipherVersion : theEncryptedCipherVersions) {
                        theCipherVersions.add(this.toDecryptedCipherVersion(eCipherVersion));
                    }
                    this._cipherVersions = theCipherVersions;
                    this._cipherVersionsLastLoadedTime = System.currentTimeMillis();
                }
            }
        }
        return this._cipherVersions;
    }

    public long getCipherVersionsExpireTimeMillis() {
        return this._cipherVersionsExpireTimeMillis;
    }

    public void setCipherVersionsExpireTimeMillis(long aCipherVersionsExpireTimeMillis) {
        this._cipherVersionsExpireTimeMillis = aCipherVersionsExpireTimeMillis;
    }

    public DecryptionService withCipherVersionsExpireTimeMillis(long aCipherVersionsExpireTimeMillis) {
        this.setCipherVersionsExpireTimeMillis(aCipherVersionsExpireTimeMillis);
        return this;
    }

    private boolean isLoadEncryptedCipherVersions(long aCurrentTimeMillis) {
        return this._cipherVersionsExpireTimeMillis == EXPIRE_TIME_IMMEDIATELY || this._cipherVersions == null || this._cipherVersionsExpireTimeMillis > 0L && aCurrentTimeMillis - this._cipherVersionsExpireTimeMillis > this._cipherVersionsLastLoadedTime;
    }

    protected abstract String toSignature(String var1);

    protected abstract String createMessage();

    protected abstract <CV extends CipherVersion> CV toDecryptedCipherVersion(CV var1);
}

