/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.RetryCount;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.data.Text;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.forwardsecrecy.CipherUidAlreadyInUseException;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.CipherVersionGenerator;
import org.refcodes.forwardsecrecy.EncryptionServer;
import org.refcodes.forwardsecrecy.EncryptionService;
import org.refcodes.forwardsecrecy.UnexpectedForwardSecrecyRuntimeException;

public abstract class AbstractEncryptionService
implements EncryptionService {
    private static Logger LOGGER = Logger.getLogger(AbstractEncryptionService.class.getName());
    private CipherVersionGenerator<CipherVersion> _cipherVersionGenerator;
    private String _namespace;
    private EncryptionServer _encryptionServer;

    public AbstractEncryptionService(String aNamespace, EncryptionServer aEncryptionServer, CipherVersionGenerator<CipherVersion> aCipherVersionGenerator) {
        this._cipherVersionGenerator = aCipherVersionGenerator;
        this._encryptionServer = aEncryptionServer;
        this._namespace = aNamespace;
    }

    @Override
    public CipherVersion next() {
        Object eCipherVersion = null;
        RetryCounter theRetryCounter = new RetryCounter(RetryCount.NORM.getValue().intValue(), (long)SleepLoopTime.MIN.getTimeMillis());
        while (theRetryCounter.nextRetry()) {
            try {
                eCipherVersion = this._cipherVersionGenerator.next();
                this._encryptionServer.addCipherVersion(this._namespace, (CipherVersion)this.toEncryptedCipherVersion(eCipherVersion));
                return eCipherVersion;
            }
            catch (CipherUidAlreadyInUseException e) {
                if (theRetryCounter.hasNextRetry()) continue;
                LOGGER.log(Level.WARNING, "Failed to add a cipher UID \"" + eCipherVersion.getUniversalId() + "\", retry count is <" + theRetryCounter.getRetryCount() + "> of <" + theRetryCounter.getRetryNumber() + "> (waiting for <" + theRetryCounter.getNextRetryDelayMillis() / 1000L + "> seconds before next retry): \"" + ExceptionUtility.toMessage((Throwable)((Object)e)) + "\"");
            }
        }
        throw new UnexpectedForwardSecrecyRuntimeException("Unable to generate a Chipher-Version within <" + theRetryCounter.getRetryNumber() + "> tries, aborting as else we might loop infinte time!");
    }

    public boolean hasNext() {
        return true;
    }

    public void remove() {
        throw new UnsupportedOperationException(Text.UNSUPPORTED_OPERATION.getText());
    }

    protected abstract <CV extends CipherVersion> CV toEncryptedCipherVersion(CV var1);
}

