/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.refcodes.controlflow.RetryCounter;
import org.refcodes.data.Encoding;
import org.refcodes.data.IoRetryCount;
import org.refcodes.data.LatencySleepTime;
import org.refcodes.data.LoopExtensionTime;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.DecryptionProvider;
import org.refcodes.forwardsecrecy.DecryptionService;
import org.refcodes.forwardsecrecy.ForwardSecrecyUtility;
import org.refcodes.forwardsecrecy.NoCipherUidException;
import org.refcodes.forwardsecrecy.UnknownCipherUidException;
import org.refcodes.security.Algorithm;
import org.refcodes.security.DecryptionException;

public class DecryptionProviderImpl
implements DecryptionProvider {
    private static Logger LOGGER = Logger.getLogger(DecryptionProviderImpl.class.getName());
    private DecryptionService _decryptionService;
    private Provider _jceProvider;
    private String _jceAlgorithm;
    private Map<String, StandardPBEStringEncryptor> _cipherUidToStringEncryptor = new WeakHashMap<String, StandardPBEStringEncryptor>();

    public DecryptionProviderImpl(DecryptionService aDecryptionService, Provider aJceProvider, String aJceAlgorithm) {
        this._decryptionService = aDecryptionService;
        this._jceProvider = aJceProvider;
        this._jceAlgorithm = aJceAlgorithm;
    }

    public DecryptionProviderImpl(DecryptionService aDecryptionService) {
        this(aDecryptionService, (Provider)new BouncyCastleProvider(), Algorithm.AES.getName());
    }

    @Override
    public String toDecrypted(String aInput) throws UnknownCipherUidException, NoCipherUidException {
        String theCipherUid = ForwardSecrecyUtility.toCipherUidPrefix(aInput);
        if (theCipherUid == null || theCipherUid.length() == 0) {
            throw new NoCipherUidException("No cipher UID has been provided by the encrypted text to be decrypted!");
        }
        CipherVersion theCipherVersion = this.getCipherVersion(theCipherUid);
        String theEncyrptedText = ForwardSecrecyUtility.toEncryptedTextBody(aInput);
        StringEncryptor theTextEncryptor = this.getStringEncryptor(theCipherVersion);
        String theDecryptedText = theTextEncryptor.decrypt(theEncyrptedText);
        return theDecryptedText;
    }

    public int toDecrypted(byte[] aInput, int aInputOffset, int aInputLength, byte[] aOutput, int aOutputOffset) throws DecryptionException {
        byte[] theOutputHex;
        String theInputText;
        byte[] theInputHex = Arrays.copyOfRange(aInput, aInputOffset, aInputOffset + aInputLength);
        try {
            theInputText = new String(theInputHex, Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException e) {
            theInputText = new String(theInputHex);
        }
        String theOutputText = this.toDecrypted(theInputText);
        try {
            theOutputHex = theOutputText.getBytes(Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException e) {
            theOutputHex = theOutputText.getBytes();
        }
        if (aOutput.length < aOutputOffset + theOutputHex.length) {
            throw new ArrayIndexOutOfBoundsException("The decrypted data is of length <" + theOutputHex.length + "> though your buffer with length <" + aOutput.length + "> does not provide enugh elements after offset <" + aOutputOffset + ">.");
        }
        int i = 0;
        while (i < theOutputHex.length) {
            aOutput[aOutputOffset + i] = theOutputHex[i];
            ++i;
        }
        return theOutputHex.length;
    }

    public void dispose() {
        Provider theProvider;
        Map<String, StandardPBEStringEncryptor> theMap = this._cipherUidToStringEncryptor;
        if (theMap != null) {
            theMap.clear();
            this._cipherUidToStringEncryptor = null;
        }
        if ((theProvider = this._jceProvider) != null) {
            theProvider.clear();
            this._jceProvider = null;
        }
        this._decryptionService = null;
        this._jceAlgorithm = null;
    }

    private CipherVersion getCipherVersion(String aCipherUid) throws UnknownCipherUidException {
        RetryCounter theRetryCounter = new RetryCounter(IoRetryCount.NORM.getValue().intValue(), (long)LatencySleepTime.MIN.getTimeMillis(), (long)LoopExtensionTime.NORM.getTimeMillis());
        while (theRetryCounter.nextRetry()) {
            List<CipherVersion> theCipherVersions = this._decryptionService.getCipherVersions();
            if (theCipherVersions != null) {
                for (CipherVersion eCipherVersion : theCipherVersions) {
                    if (!eCipherVersion.getUniversalId().equals(aCipherUid)) continue;
                    return eCipherVersion;
                }
            }
            if (!theRetryCounter.hasNextRetry()) continue;
            LOGGER.log(Level.WARNING, "No cipher found for cipher UID \"" + aCipherUid + "\", retry count is <" + theRetryCounter.getRetryCount() + "> of <" + theRetryCounter.getRetryNumber() + "> (waiting for <" + theRetryCounter.getNextRetryDelayMillis() / 1000L + "> seconds before next retry) ...");
        }
        throw new UnknownCipherUidException(aCipherUid, "No cipher version found for cipher UID \"" + aCipherUid + "\" after <" + theRetryCounter.getRetryNumber() + "> retries!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringEncryptor getStringEncryptor(CipherVersion aCipherVersion) {
        StandardPBEStringEncryptor theStringEncryptor = this._cipherUidToStringEncryptor.get(aCipherVersion.getCipher());
        if (theStringEncryptor == null) {
            DecryptionProviderImpl decryptionProviderImpl = this;
            synchronized (decryptionProviderImpl) {
                theStringEncryptor = this._cipherUidToStringEncryptor.get(aCipherVersion.getCipher());
                if (theStringEncryptor == null) {
                    theStringEncryptor = new StandardPBEStringEncryptor();
                    theStringEncryptor.setProvider(this._jceProvider);
                    theStringEncryptor.setAlgorithm(this._jceAlgorithm);
                    theStringEncryptor.setPassword(aCipherVersion.getCipher());
                    this._cipherUidToStringEncryptor.put(aCipherVersion.getUniversalId(), theStringEncryptor);
                }
            }
        }
        return theStringEncryptor;
    }
}

