/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.exceptions.EncryptionOperationNotPossibleException;
import org.refcodes.data.Delimiter;
import org.refcodes.data.Encoding;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.forwardsecrecy.EncryptionProvider;
import org.refcodes.forwardsecrecy.EncryptionService;
import org.refcodes.forwardsecrecy.ForwardSecrecyUtility;
import org.refcodes.security.Algorithm;
import org.refcodes.security.EncryptionException;

public class EncryptionProviderImpl
implements EncryptionProvider {
    private static Logger LOGGER = Logger.getLogger(EncryptionProviderImpl.class.getName());
    private EncryptionService _encryptionService;
    private StandardPBEStringEncryptor _stringEncryptor;
    private String _cipherUid = null;
    private Provider _jceProvider;
    private String _jceAlgorithm;

    public EncryptionProviderImpl(EncryptionService aEncryptionService, Provider aJceProvider, String aJceAlgorithm) {
        this._encryptionService = aEncryptionService;
        this._jceProvider = aJceProvider;
        this._jceAlgorithm = aJceAlgorithm;
        this.nextCipherVersion();
    }

    public EncryptionProviderImpl(EncryptionService aEncryptionService) {
        this(aEncryptionService, (Provider)new BouncyCastleProvider(), Algorithm.AES.getName());
    }

    @Override
    public String toEncrypted(String aInput) throws EncryptionException {
        if (ForwardSecrecyUtility.hasEncryptionPattern(aInput)) {
            LOGGER.log(Level.WARNING, "The provided text may have already been encrypted with a cipher UID beginning with \"" + aInput.substring(0, 14) + "...\"!");
        }
        try {
            return String.valueOf(this._cipherUid) + Delimiter.CIPHER_UID.getChar() + this._stringEncryptor.encrypt(aInput);
        }
        catch (EncryptionInitializationException | EncryptionOperationNotPossibleException e) {
            throw new EncryptionException(ExceptionUtility.toMessage((Throwable)e), e);
        }
    }

    public int toEncrypted(byte[] abUFFER, int aOffset, int aLength, byte[] aOutBuffer, int aOutOffset) throws EncryptionException {
        byte[] theOutputHex;
        String theInputText;
        byte[] theInputHex = Arrays.copyOfRange(abUFFER, aOffset, aOffset + aLength);
        try {
            theInputText = new String(theInputHex, Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException e) {
            theInputText = new String(theInputHex);
        }
        String theOutputText = this.toEncrypted(theInputText);
        try {
            theOutputHex = theOutputText.getBytes(Encoding.UTF_8.getCode());
        }
        catch (UnsupportedEncodingException e) {
            theOutputHex = theOutputText.getBytes();
        }
        if (aOutBuffer.length < aOutOffset + theOutputHex.length) {
            throw new ArrayIndexOutOfBoundsException("The encrypted data is of length <" + theOutputHex.length + "> though your buffer with length <" + aOutBuffer.length + "> does not provide enugh elements after offset <" + aOutOffset + ">.");
        }
        int i = 0;
        while (i < theOutputHex.length) {
            aOutBuffer[aOutOffset + i] = theOutputHex[i];
            ++i;
        }
        return theOutputHex.length;
    }

    @Override
    public void nextCipherVersion() {
        Object theCipherVersion = this._encryptionService.next();
        this._stringEncryptor = new StandardPBEStringEncryptor();
        this._stringEncryptor.setProvider(this._jceProvider);
        this._stringEncryptor.setAlgorithm(this._jceAlgorithm);
        this._stringEncryptor.setPassword(theCipherVersion.getCipher());
        this._cipherUid = theCipherVersion.getUniversalId();
    }

    public void dispose() {
        Provider theProvider = this._jceProvider;
        if (theProvider != null) {
            theProvider.clear();
            this._jceProvider = null;
        }
        this._encryptionService = null;
        this._jceAlgorithm = null;
        this._cipherUid = null;
        this._stringEncryptor = null;
    }
}

