/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jasypt.util.text.BasicTextEncryptor;
import org.refcodes.data.Delimiter;
import org.refcodes.data.License;
import org.refcodes.textual.HorizAlignTextBuilder;
import org.refcodes.textual.HorizAlignTextMode;
import org.refcodes.textual.RandomTextGenerartor;
import org.refcodes.textual.RandomTextMode;

public final class ForwardSecrecyUtility {
    public static final int CIPHER_LENGTH = 48;
    public static final int MESSAGE_LENGTH = 256;
    private static Logger LOGGER = Logger.getLogger(ForwardSecrecyUtility.class.getName());
    private static BasicTextEncryptor TEXT_ENCRYPTOR;
    private static RandomTextGenerartor RND_CIPHER_GENERATOR;
    private static RandomTextGenerartor RND_MESSAGE_GENERATOR;
    private static final String BOUNCY_CASTLE_PROVIDER = "BC";
    private static final char CIPHER_UID_TIMESTAMP_SEPARATOR = '-';
    public static final int CIPHER_UID_TIMESTAMP_LENGTH = 14;
    public static final int CIPHER_UID_LENGTH = 24;

    static {
        RND_CIPHER_GENERATOR = new RandomTextGenerartor().withColumnWidth(48).withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        RND_MESSAGE_GENERATOR = new RandomTextGenerartor().withColumnWidth(256).withRandomTextMode(RandomTextMode.ALPHANUMERIC);
        String thePassPhrase = null;
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface eNetworkInterface = e.nextElement();
                try {
                    byte[] eHardwareAddress = eNetworkInterface.getHardwareAddress();
                    if (eHardwareAddress == null) continue;
                    thePassPhrase = "";
                    int i = 0;
                    while (i < eHardwareAddress.length) {
                        thePassPhrase = String.valueOf(thePassPhrase) + (eHardwareAddress[i] < 0 ? "" + (eHardwareAddress[i] & 0xFF) : "" + eHardwareAddress[i]);
                        if (i < eHardwareAddress.length - 1) {
                            thePassPhrase = String.valueOf(thePassPhrase) + ".";
                        }
                        ++i;
                    }
                    break;
                }
                catch (SocketException se) {
                    LOGGER.log(Level.WARNING, "Unable to acquire network interfaces's (\"" + eNetworkInterface.getDisplayName() + "\") hardware address, trying next network interface.", se);
                }
            }
        }
        catch (SocketException se) {
            LOGGER.log(Level.WARNING, "Unable to acquire machine's network interfaces (using alternate cipher).", se);
        }
        if (thePassPhrase == null) {
            thePassPhrase = License.REFCODES_LICENSE.getText();
        }
        TEXT_ENCRYPTOR = new BasicTextEncryptor();
        TEXT_ENCRYPTOR.setPassword(thePassPhrase);
    }

    private ForwardSecrecyUtility() {
    }

    public static boolean hasEncryptionPattern(String aText) {
        if (aText.length() < 24) {
            return false;
        }
        if (aText.charAt(24) != Delimiter.CIPHER_UID.getChar()) {
            return false;
        }
        return aText.charAt(13) == '-';
    }

    public static String toCipherUidPrefix(String aCipherUidWithEncryptedText) {
        int theIndex = aCipherUidWithEncryptedText.indexOf(Delimiter.CIPHER_UID.getChar());
        if (theIndex == -1) {
            return null;
        }
        return aCipherUidWithEncryptedText.substring(0, theIndex);
    }

    public static String toEncryptedTextBody(String aCipherUidWithEncryptedText) {
        int theIndex = aCipherUidWithEncryptedText.indexOf(Delimiter.CIPHER_UID.getChar());
        if (theIndex == -1) {
            return null;
        }
        return aCipherUidWithEncryptedText.substring(theIndex + 1);
    }

    public static String createCipherUid() {
        String theCipherUid = String.valueOf(System.currentTimeMillis()) + '-';
        theCipherUid = ((HorizAlignTextBuilder)new HorizAlignTextBuilder().withHorizAlignTextMode(HorizAlignTextMode.RIGHT).withText(new String[]{theCipherUid})).withColumnWidth(14).withFillChar('0').toString();
        theCipherUid = String.valueOf(theCipherUid) + new RandomTextGenerartor().withColumnWidth(24 - theCipherUid.length()).withRandomTextMode(RandomTextMode.ALPHANUMERIC).next();
        return theCipherUid;
    }

    public static String createCipher() {
        return RND_CIPHER_GENERATOR.next();
    }

    public static String createMessage() {
        return RND_MESSAGE_GENERATOR.next();
    }

    /*
     * Exception decompiling
     */
    public static PrivateKey readPrivateKey(File aFile, String aPassword) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static PublicKey readPublicKey(File aFile) throws InvalidKeySpecException, NoSuchAlgorithmException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 10[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

