/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.forwardsecrecy;

import edu.vt.middleware.crypt.CryptException;
import edu.vt.middleware.crypt.asymmetric.AsymmetricAlgorithm;
import edu.vt.middleware.crypt.asymmetric.RSA;
import edu.vt.middleware.crypt.util.Base64Converter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.forwardsecrecy.AbstractEncryptionService;
import org.refcodes.forwardsecrecy.CipherVersion;
import org.refcodes.forwardsecrecy.CipherVersionFactory;
import org.refcodes.forwardsecrecy.CipherVersionFactoryImpl;
import org.refcodes.forwardsecrecy.CipherVersionGenerator;
import org.refcodes.forwardsecrecy.CipherVersionGeneratorImpl;
import org.refcodes.forwardsecrecy.EncryptCipherRuntimeException;
import org.refcodes.forwardsecrecy.EncryptionServer;
import org.refcodes.forwardsecrecy.ForwardSecrecyUtility;

public class PublicKeyEncryptionService
extends AbstractEncryptionService {
    private static Logger LOGGER = Logger.getLogger(PublicKeyEncryptionService.class.getName());
    private CipherVersionFactory<CipherVersion> _cipherVersionFactory;
    private AsymmetricAlgorithm _encryptAlgorithm = new RSA();
    private Base64Converter _base64Converter = new Base64Converter();
    private String _publicKeyPath;

    public PublicKeyEncryptionService(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer) throws CryptException, IOException, GeneralSecurityException {
        this(aNamespace, aPublicKeyPath, aEncryptionServer, new CipherVersionGeneratorImpl(), new CipherVersionFactoryImpl());
    }

    public PublicKeyEncryptionService(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer, CipherVersionGenerator<CipherVersion> aCipherVersionGenerator) throws CryptException, IOException, GeneralSecurityException {
        this(aNamespace, aPublicKeyPath, aEncryptionServer, aCipherVersionGenerator, new CipherVersionFactoryImpl());
    }

    public PublicKeyEncryptionService(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws CryptException, IOException, GeneralSecurityException {
        this(aNamespace, aPublicKeyPath, aEncryptionServer, new CipherVersionGeneratorImpl(), aCipherVersionFactory);
    }

    public PublicKeyEncryptionService(String aNamespace, String aPublicKeyPath, EncryptionServer aEncryptionServer, CipherVersionGenerator<CipherVersion> aCipherVersionGenerator, CipherVersionFactory<CipherVersion> aCipherVersionFactory) throws GeneralSecurityException, CryptException, IOException {
        super(aNamespace, aEncryptionServer, aCipherVersionGenerator);
        this._cipherVersionFactory = aCipherVersionFactory;
        this._publicKeyPath = aPublicKeyPath;
        File thePublicKeyFile = new File(aPublicKeyPath);
        LOGGER.log(Level.FINE, "Loading public key from file \"" + thePublicKeyFile.getAbsolutePath() + "\"...");
        try {
            PublicKey thePublicKey = ForwardSecrecyUtility.readPublicKey(thePublicKeyFile);
            this._encryptAlgorithm.setKey(thePublicKey);
            this._encryptAlgorithm.initEncrypt();
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.WARNING, "Public key file \"" + thePublicKeyFile.getAbsolutePath() + "\" not found: " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to load public key from file \"" + thePublicKeyFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
        catch (GeneralSecurityException e) {
            LOGGER.log(Level.WARNING, "Encountered a security problem loading public key from file \"" + thePublicKeyFile.getAbsolutePath() + "\": " + ExceptionUtility.toMessage((Throwable)e));
            throw e;
        }
    }

    @Override
    protected <CV extends CipherVersion> CV toEncryptedCipherVersion(CV aDecryptedCipherVersion) {
        LOGGER.log(Level.FINE, "Using public key \"" + this._publicKeyPath + "\" for encrypting ...");
        try {
            return (CV)this._cipherVersionFactory.createInstance(aDecryptedCipherVersion.getUniversalId(), this._encryptAlgorithm.encrypt(aDecryptedCipherVersion.getCipher().getBytes(), this._base64Converter));
        }
        catch (CryptException e) {
            throw new EncryptCipherRuntimeException(e.getMessage(), e);
        }
    }
}

